/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.search.AttachmentOnlyReIndexSupport;
import com.atlassian.confluence.search.ContentOnlyReIndexSupport;
import com.atlassian.confluence.search.ReIndexOption;
import com.atlassian.confluence.search.ReIndexSupport;
import com.atlassian.confluence.search.UserOnlyReIndexSupport;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.atlassian.confluence.user.PersonalInformation;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ReIndexUtils {
    public static final SearchQuery ATTACHMENT_ONLY_QUERY = new TermQuery(SearchFieldMappings.CLASS_NAME.getName(), Attachment.class.getName());
    public static final SearchQuery USER_ONLY_QUERY = new TermQuery(SearchFieldMappings.CLASS_NAME.getName(), PersonalInformation.class.getName());
    public static final SearchQuery CONTENT_ONLY_QUERY = (SearchQuery)BooleanQuery.builder().addMustNot((U[])new SearchQuery[]{ATTACHMENT_ONLY_QUERY, USER_ONLY_QUERY}).build();
    public static final Function<String, SearchQuery> ATTACHMENT_ONLY_IN_SPACE_QUERY = spaceKey -> (SearchQuery)BooleanQuery.builder().addMust((U[])new SearchQuery[]{new TermQuery(SearchFieldMappings.CLASS_NAME.getName(), Attachment.class.getName()), new InSpaceQuery((String)spaceKey)}).build();
    public static final Function<String, SearchQuery> CONTENT_ONLY_IN_SPACE_QUERY = spaceKey -> (SearchQuery)BooleanQuery.builder().addMustNot((U[])new SearchQuery[]{ATTACHMENT_ONLY_QUERY, USER_ONLY_QUERY}).addMust(new InSpaceQuery((String)spaceKey)).build();
    public static final Predicate<String> USER_CLASS = x -> PersonalInformation.class.getName().equals(x);
    public static final Predicate<String> ATTACHMENT_CLASS = x -> Attachment.class.getName().equals(x);
    public static final Predicate<String> CONTENT_CLASSES = USER_CLASS.negate().and(ATTACHMENT_CLASS.negate());

    private ReIndexUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFullReindex(Set<ReIndexSupport> options) {
        if (!options.stream().anyMatch(ContentOnlyReIndexSupport.class::isInstance)) return false;
        if (!options.stream().anyMatch(AttachmentOnlyReIndexSupport.class::isInstance)) return false;
        if (!options.stream().anyMatch(UserOnlyReIndexSupport.class::isInstance)) return false;
        return true;
    }

    public static Set<ReIndexSupport> fullReindex() {
        return ReIndexUtils.fullReindex(true);
    }

    public static Set<ReIndexSupport> fullReindex(boolean reindexingSite) {
        return reindexingSite ? Set.of(new ContentOnlyReIndexSupport(), new AttachmentOnlyReIndexSupport(), new UserOnlyReIndexSupport()) : Set.of(new ContentOnlyReIndexSupport(), new AttachmentOnlyReIndexSupport());
    }

    public static EnumSet<ReIndexOption> fromApiEnumSet(EnumSet<com.atlassian.confluence.api.service.index.ReIndexOption> apiOptions, boolean reindexingSite) {
        EnumSet<ReIndexOption> options = EnumSet.noneOf(ReIndexOption.class);
        if (apiOptions.contains(com.atlassian.confluence.api.service.index.ReIndexOption.CONTENT_ONLY)) {
            options.add(ReIndexOption.CONTENT_ONLY);
        }
        if (apiOptions.contains(com.atlassian.confluence.api.service.index.ReIndexOption.ATTACHMENT_ONLY)) {
            options.add(ReIndexOption.ATTACHMENT_ONLY);
        }
        if (apiOptions.contains(com.atlassian.confluence.api.service.index.ReIndexOption.USER_ONLY) && reindexingSite) {
            options.add(ReIndexOption.USER_ONLY);
        }
        return options;
    }
}

