/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.impl.util.OptionalUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.EnumUtils;

public enum SearchPlatform {
    OPENSEARCH("OpenSearch", true),
    LUCENE("Lucene");

    public static final String CONFIG_KEY = "search.platform";
    public static final SearchPlatform DEFAULT;
    private final String friendlyName;
    private final boolean isSupportsDocumentId;

    private SearchPlatform(String friendlyName) {
        this(friendlyName, false);
    }

    private SearchPlatform(String friendlyName, boolean isSupportsDocumentId) {
        this.friendlyName = friendlyName;
        this.isSupportsDocumentId = isSupportsDocumentId;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public boolean isSupportsDocumentId() {
        return this.isSupportsDocumentId;
    }

    public static SearchPlatform getSearchPlatform(ApplicationConfiguration applicationConfig) {
        Objects.requireNonNull(applicationConfig, "applicationConfig is required");
        return OptionalUtils.firstNonEmpty((Supplier[])new Supplier[]{() -> Optional.ofNullable(System.getProperty(CONFIG_KEY)), () -> Optional.ofNullable(applicationConfig.getProperty((Object)CONFIG_KEY)).map(String::valueOf)}).map(SearchPlatform::parse).orElse(DEFAULT);
    }

    public static SearchPlatform parse(String str) {
        SearchPlatform platform = (SearchPlatform)EnumUtils.getEnumIgnoreCase(SearchPlatform.class, (String)str);
        if (platform == null) {
            throw new IllegalArgumentException("Invalid search platform: " + str);
        }
        return platform;
    }

    static {
        DEFAULT = LUCENE;
    }
}

