/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2;

import com.atlassian.confluence.search.v2.DefaultSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.Index;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractSearch
implements ISearch {
    protected final List<Index> indices;
    protected final SearchQuery query;
    protected final SearchSort sort;
    protected final int startOffset;
    protected final int limit;
    protected final boolean generatesToken;

    @Deprecated(since="9.0", forRemoval=true)
    protected AbstractSearch(EnumSet<SearchIndex> indexes, @NonNull SearchQuery query, SearchSort sort) {
        this(Index.from(indexes), query, sort, 0, 10);
    }

    @Deprecated(since="9.0", forRemoval=true)
    protected AbstractSearch(List<Index> indexes, @NonNull SearchQuery query, SearchSort sort, int startOffset, int limit) {
        this(((DefaultSearch.Builder)((DefaultSearch.Builder)((DefaultSearch.Builder)((DefaultSearch.Builder)DefaultSearch.builder().indices((List)indexes)).query(query)).sort(sort)).startOffset(startOffset)).limit(limit));
    }

    protected AbstractSearch(AbstractBuilder<?> builder) {
        Preconditions.checkArgument((builder.query != null ? 1 : 0) != 0, (Object)"query should be non-null");
        Preconditions.checkArgument((builder.startOffset >= 0 ? 1 : 0) != 0, (Object)"startOffset should be a non-negative number");
        Preconditions.checkArgument((builder.limit > 0 ? 1 : 0) != 0, (Object)"limit should be a positive number");
        Preconditions.checkNotNull(builder.indices, (Object)"indices should be non-null");
        this.indices = builder.indices;
        this.query = builder.query;
        this.sort = builder.sort;
        this.startOffset = builder.startOffset;
        this.limit = builder.limit;
        this.generatesToken = builder.generatesToken;
    }

    @Override
    public @NonNull SearchQuery getQuery() {
        return this.query;
    }

    @Override
    public SearchSort getSort() {
        return this.sort;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public EnumSet<SearchIndex> getSearchIndexes() {
        Set searchIndexes = this.indices.stream().map(SearchIndex::fromIndex).filter(Objects::nonNull).collect(Collectors.toSet());
        return searchIndexes.isEmpty() ? EnumSet.noneOf(SearchIndex.class) : EnumSet.copyOf(searchIndexes);
    }

    @Override
    public List<Index> getIndices() {
        return this.indices;
    }

    @Override
    public boolean generatesToken() {
        return this.generatesToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSearch that = (AbstractSearch)o;
        return this.startOffset == that.startOffset && this.limit == that.limit && Objects.equals(this.indices, that.indices) && Objects.equals(this.query, that.query) && Objects.equals(this.sort, that.sort) && Objects.equals(this.generatesToken, that.generatesToken);
    }

    public int hashCode() {
        return Objects.hash(this.indices, this.query, this.sort, this.startOffset, this.limit, this.generatesToken);
    }

    protected static abstract class AbstractBuilder<SELF extends AbstractBuilder<SELF>>
    implements ISearch.Builder<ISearch> {
        protected List<Index> indices;
        protected SearchQuery query;
        protected SearchSort sort;
        protected int startOffset;
        protected int limit = 10;
        protected boolean generatesToken;

        protected AbstractBuilder() {
        }

        public SELF copyFrom(ISearch search) {
            return (SELF)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)this.indices((List)search.getIndices())).query(search.getQuery())).sort(search.getSort())).startOffset(search.getStartOffset())).limit(search.getLimit())).generatesToken(search.generatesToken());
        }

        public SELF indices(Index ... indices) {
            return (SELF)this.indices((List)List.of(indices));
        }

        public SELF indices(List<Index> indices) {
            this.indices = indices;
            return (SELF)this;
        }

        public SELF query(SearchQuery query) {
            this.query = query;
            return (SELF)this;
        }

        public SELF sort(SearchSort sort) {
            this.sort = sort;
            return (SELF)this;
        }

        public SELF startOffset(int startOffset) {
            this.startOffset = startOffset;
            return (SELF)this;
        }

        public SELF limit(int limit) {
            this.limit = limit;
            return (SELF)this;
        }

        public SELF generatesToken(boolean generatesToken) {
            this.generatesToken = generatesToken;
            return (SELF)this;
        }
    }
}

