/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2;

import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.impl.search.v2.UserLookupHelper;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.LabelPermissionSupport;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.lucene.LuceneUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class AbstractSearchResult
implements SearchResult {
    private static final String CREATOR_FULLNAME_FIELD = "creator-full-name";
    private Set<String> personalLabels;
    private Map<String, String> extraFields;
    private final Function<String, ConfluenceUser> userLookup;
    private final Supplier<ConfluenceUser> creatorUser = Suppliers.memoize(() -> this.getUserResult(SearchFieldMappings.CREATOR.getName()));
    private final Supplier<ConfluenceUser> lastModifierUser = Suppliers.memoize(() -> this.getUserResult(SearchFieldMappings.LAST_MODIFIER.getName()));
    static final Map<String, String> INDEX_FIELD_MAPPINGS = ImmutableMap.builder().put((Object)"attachmentDownloadPath", (Object)SearchFieldMappings.ATTACHMENT_DOWNLOAD_PATH.getName()).put((Object)"attachmentTypeDescription", (Object)SearchFieldMappings.ATTACHMENT_NICE_TYPE.getName()).put((Object)"attachmentReadableFileSize", (Object)SearchFieldMappings.ATTACHMENT_NICE_FILE_SIZE.getName()).put((Object)"attachmentMimeType", (Object)SearchFieldMappings.ATTACHMENT_MIME_TYPE.getName()).put((Object)"containingContentDisplayTitle", (Object)SearchFieldMappings.ATTACHMENT_OWNER_REAL_TITLE.getName()).put((Object)"containingPageDisplayTitle", (Object)SearchFieldMappings.PAGE_DISPLAY_TITLE.getName()).put((Object)"containingContentUrlPath", (Object)SearchFieldMappings.ATTACHMENT_OWNER_URL_PATH.getName()).put((Object)"containingPageUrlPath", (Object)SearchFieldMappings.PAGE_URL_PATH.getName()).put((Object)"containingContentId", (Object)SearchFieldMappings.ATTACHMENT_OWNER_ID.getName()).put((Object)"username", (Object)SearchFieldMappings.USER_NAME.getName()).put((Object)"fullName", (Object)SearchFieldMappings.FULL_NAME.getName()).put((Object)"email", (Object)SearchFieldMappings.EMAIL.getName()).put((Object)SearchFieldMappings.CONTENT_VERSION.getName(), (Object)SearchFieldMappings.CONTENT_VERSION.getName()).put((Object)SearchFieldMappings.LATEST_VERSION_ID.getName(), (Object)SearchFieldMappings.LATEST_VERSION_ID.getName()).put((Object)"creatorFullName", (Object)"creator-full-name").put((Object)"contentPluginKey", (Object)SearchFieldMappings.CONTENT_PLUGIN_KEY.getName()).build();

    protected AbstractSearchResult() {
        this((Function<String, ConfluenceUser>)((Object)UserLookupHelper.INSTANCE));
    }

    public AbstractSearchResult(Function<String, ConfluenceUser> userLookup) {
        this.userLookup = userLookup;
    }

    @Override
    public Set<String> getLabels(User user) {
        HashSet<String> result = new HashSet<String>();
        String labelText = this.getStringResult(SearchFieldMappings.LABEL_TEXT.getName());
        StringTokenizer tokenizer = new StringTokenizer(labelText, " ");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        if (user != null) {
            List<Label> labels = new ArrayList(this.getPersonalLabels().size());
            for (String personalLabel : this.getPersonalLabels()) {
                ParsedLabelName parsedLabel = LabelParser.parse(personalLabel, AuthenticatedUserThreadLocal.get());
                if (parsedLabel == null) continue;
                labels.add(parsedLabel.toLabel());
            }
            labels = LabelPermissionSupport.filterVisibleLabels(labels, user, true);
            for (Label filteredLabel : labels) {
                result.add(filteredLabel.toString());
            }
        }
        return result;
    }

    @Override
    public Set<String> getPersonalLabels() {
        if (this.personalLabels == null) {
            this.personalLabels = this.getFieldValues(SearchFieldMappings.LABEL.getName()).stream().filter(text -> text != null && text.startsWith("~")).collect(Collectors.toSet());
        }
        return this.personalLabels;
    }

    @Override
    public String getContent() {
        return this.getStringResult(SearchFieldMappings.CONTENT_STORED.getName());
    }

    protected String getSanitisedContent() {
        String title = this.getDisplayTitle();
        return Optional.ofNullable(this.getContent()).map(String::trim).map(content -> content.startsWith(title) ? content.substring(title.length()) : content).map(String::trim).orElse("");
    }

    protected String getResultExcerpt(int maxLength) {
        String sanitised = this.getSanitisedContent();
        return sanitised.substring(0, Math.min(maxLength, sanitised.length()));
    }

    @Override
    public String getResultExcerpt() {
        return this.getResultExcerpt(320);
    }

    @Override
    public String getType() {
        return this.getStringResult(SearchFieldMappings.TYPE.getName());
    }

    @Override
    public String getStatus() {
        return this.getStringResult(SearchFieldMappings.CONTENT_STATUS.getName());
    }

    @Override
    public boolean isHomePage() {
        return Boolean.valueOf(this.getStringResult(SearchFieldMappings.HOME_PAGE.getName()));
    }

    @Override
    public Date getCreationDate() {
        return this.getDateResult(SearchFieldMappings.CREATION_DATE.getName());
    }

    @Override
    @Deprecated
    public String getCreator() {
        ConfluenceUser creator = this.getCreatorUser();
        return creator != null ? creator.getName() : null;
    }

    @Override
    public ConfluenceUser getCreatorUser() {
        return (ConfluenceUser)this.creatorUser.get();
    }

    @Override
    public String getOwnerType() {
        String className = this.getStringResult(SearchFieldMappings.ATTACHMENT_OWNER_CONTENT_TYPE.getName());
        return className == null ? null : ContentTypeEnum.getByClassName(className).getRepresentation();
    }

    @Override
    public String getOwnerTitle() {
        return this.getStringResult(this.getStringResult(SearchFieldMappings.ATTACHMENT_OWNER_CONTENT_TYPE.getName()));
    }

    @Override
    public Integer getContentVersion() {
        return this.getIntegerResult(SearchFieldMappings.CONTENT_VERSION.getName());
    }

    @Override
    public Date getLastModificationDate() {
        return this.getDateResult(SearchFieldMappings.LAST_MODIFICATION_DATE.getName());
    }

    @Override
    @Deprecated
    public String getLastModifier() {
        ConfluenceUser lastModifier = this.getLastModifierUser();
        return lastModifier != null ? lastModifier.getName() : null;
    }

    @Override
    public ConfluenceUser getLastModifierUser() {
        return (ConfluenceUser)this.lastModifierUser.get();
    }

    @Override
    public String getDisplayTitle() {
        return this.getStringResult(SearchFieldMappings.TITLE.getName());
    }

    @Override
    public String getUrlPath() {
        return this.getStringResult(SearchFieldMappings.CONTENT_URL_PATH.getName());
    }

    @Override
    public String getLastUpdateDescription() {
        return this.getStringResult(SearchFieldMappings.LAST_UPDATE_DESCRIPTION.getName());
    }

    @Override
    public String getSpaceName() {
        return this.getStringResult(SearchFieldMappings.SPACE_NAME.getName());
    }

    @Override
    public String getSpaceKey() {
        return this.getStringResult(SearchFieldMappings.SPACE_KEY.getName());
    }

    @Override
    public boolean hasLabels() {
        return this.getField(SearchFieldMappings.LABEL_TEXT.getName()) != null && this.getField(SearchFieldMappings.LABEL.getName()) != null;
    }

    @Override
    public Map<String, String> getExtraFields() {
        if (this.extraFields == null) {
            this.extraFields = new HashMap<String, String>(INDEX_FIELD_MAPPINGS.size());
            INDEX_FIELD_MAPPINGS.forEach((key, fieldName) -> {
                String fieldValue = this.getField((String)fieldName);
                if (fieldValue != null) {
                    this.extraFields.put((String)key, fieldValue);
                }
            });
        }
        return this.extraFields;
    }

    @Override
    public Handle getHandle() {
        try {
            return new HibernateHandle(this.getStringResult(SearchFieldMappings.HANDLE.getName()));
        }
        catch (ParseException p) {
            throw new IllegalStateException("Unable to create hibernate handle from search index handle: " + this.getStringResult(SearchFieldMappings.HANDLE.getName()));
        }
    }

    @Override
    public abstract Set<String> getFieldNames();

    @Override
    public String getField(String fieldName) {
        return this.getFieldValue(fieldName);
    }

    public abstract String getFieldValue(String var1);

    @Override
    public abstract Set<String> getFieldValues(String var1);

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getSpaceName()).append((Object)this.getDisplayTitle()).append((Object)this.getType()).append((Object)this.getLastModifierUser()).append((Object)this.getLastModificationDate()).append(this.getExtraFields()).toString();
    }

    protected String getStringResult(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            String fieldValue = this.getField(fieldName);
            if (fieldValue == null) continue;
            return fieldValue;
        }
        return null;
    }

    protected ConfluenceUser getUserResult(String fieldName) {
        return this.userLookup.apply(this.getStringResult(fieldName));
    }

    protected Date getDateResult(String key) {
        String value = this.getStringResult(key);
        if (value == null) {
            return null;
        }
        return LuceneUtils.stringToDate(value);
    }

    protected Integer getIntegerResult(String fieldName) {
        String value = this.getStringResult(fieldName);
        return value == null ? null : Integer.valueOf(value);
    }
}

