/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.search.SearchLanguage;
import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AtlassianDocument {
    private final ArrayListMultimap<String, FieldDescriptor> fields;
    private String id = null;
    private Optional<SearchLanguage> optionalSearchLanguage = Optional.empty();

    public AtlassianDocument() {
        this.fields = ArrayListMultimap.create();
    }

    public AtlassianDocument(Collection<FieldDescriptor> fields) {
        this.fields = ArrayListMultimap.create();
        fields.forEach(field -> this.fields.put((Object)field.getName(), field));
    }

    public Optional<SearchLanguage> getSearchLanguage() {
        return this.optionalSearchLanguage;
    }

    public void setSearchLanguage(Optional<SearchLanguage> optionalSearchLanguage) {
        this.optionalSearchLanguage = optionalSearchLanguage;
    }

    public AtlassianDocument addField(FieldDescriptor field) {
        this.fields.put((Object)field.getName(), (Object)field);
        return this;
    }

    public AtlassianDocument addFields(Collection<FieldDescriptor> fields) {
        fields.forEach(field -> this.fields.put((Object)field.getName(), field));
        return this;
    }

    public Collection<FieldDescriptor> getFields() {
        return this.fields.values();
    }

    public Optional<String> getValue(String fieldName) {
        return this.fields.get((Object)fieldName).stream().findFirst().map(descriptor -> descriptor.getValue());
    }

    public @Nullable String getId() {
        return this.id;
    }

    @ExperimentalApi
    public AtlassianDocument setId(@Nullable String id) {
        this.id = id;
        return this;
    }
}

