/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2;

import com.atlassian.confluence.search.v2.DecoratorSearchBuilder;
import com.atlassian.confluence.search.v2.HightlightParams;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.Index;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.SearchWithToken;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultSearchWithToken
implements SearchWithToken {
    private final ISearch delegate;
    private final long searchToken;

    public DefaultSearchWithToken(ISearch delegate, long searchToken) {
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkArgument((searchToken >= 0L ? 1 : 0) != 0, (Object)"searchToken must be 0 or greater");
        this.searchToken = searchToken;
        this.delegate = delegate;
    }

    @Override
    public long getSearchToken() {
        return this.searchToken;
    }

    @Override
    public @NonNull SearchQuery getQuery() {
        return this.delegate.getQuery();
    }

    @Override
    public SearchSort getSort() {
        return this.delegate.getSort();
    }

    @Override
    public int getStartOffset() {
        return this.delegate.getStartOffset();
    }

    @Override
    public int getLimit() {
        return this.delegate.getLimit();
    }

    @Override
    public String getSearchType() {
        return this.delegate.getSearchType();
    }

    @Override
    public Optional<HightlightParams> getHighlight() {
        return this.delegate.getHighlight();
    }

    @Override
    public boolean isExplain() {
        return this.delegate.isExplain();
    }

    @Override
    public boolean generatesToken() {
        return this.delegate.generatesToken();
    }

    @Override
    public EnumSet<SearchIndex> getSearchIndexes() {
        return this.delegate.getSearchIndexes();
    }

    @Override
    public List<Index> getIndices() {
        return this.delegate.getIndices();
    }

    @Override
    public ISearch.Builder<SearchWithToken> toBuilder() {
        return new DecoratorSearchBuilder<SearchWithToken>(this.delegate.toBuilder(), d -> new DefaultSearchWithToken((ISearch)d, this.searchToken));
    }
}

