/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2;

import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.mapping.FieldMapping;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.SearchIndexAccessException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldMappings {
    private static final Logger LOG = LoggerFactory.getLogger(FieldMappings.class);
    private final FieldMappingWriter writer;
    private final ConcurrentMap<String, FieldMapping> fields = new ConcurrentHashMap<String, FieldMapping>();

    public FieldMappings(FieldMappingWriter writer) {
        this.writer = Objects.requireNonNull(writer, "writer is required");
    }

    public Collection<FieldMapping> getFields() {
        return this.fields.values();
    }

    public boolean addMapping(FieldMapping mapping) {
        AtomicBoolean newlyAdded = new AtomicBoolean(false);
        FieldMapping registeredMapping = this.fields.computeIfAbsent(mapping.getName(), s -> {
            this.writer.putIfAbsent(mapping);
            newlyAdded.set(true);
            return mapping;
        });
        if (!newlyAdded.get() && !Objects.equals(registeredMapping, mapping)) {
            LOG.warn("Mapping for '{}' ({}) conflicts with existing mapping ({}).", new Object[]{mapping.getName(), mapping, registeredMapping});
        }
        return newlyAdded.get();
    }

    public void addDocumentFields(AtlassianDocument document) {
        for (FieldDescriptor f : document.getFields()) {
            FieldMapping mapping = f.getMapping();
            if (!this.addMapping(mapping)) continue;
            LOG.warn("Mapping {} was registered implicitly, use field-mappings-provider module to explicitly register field mappings in index", (Object)mapping.getName());
        }
    }

    public static interface FieldMappingWriter {
        public boolean putIfAbsent(FieldMapping var1) throws SearchIndexAccessException;
    }
}

