/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2;

import com.atlassian.confluence.search.v2.HightlightParams;
import com.atlassian.confluence.search.v2.Index;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface ISearch {
    public static final String ENABLE_LUCENE_QUERY_EXPLAIN = "confluence.lucene.query.explain";

    public @NonNull SearchQuery getQuery();

    public SearchSort getSort();

    public int getStartOffset();

    public int getLimit();

    default public String getSearchType() {
        return this.getClass().getSimpleName();
    }

    default public Optional<HightlightParams> getHighlight() {
        return Optional.empty();
    }

    default public boolean isExplain() {
        return Boolean.getBoolean(ENABLE_LUCENE_QUERY_EXPLAIN);
    }

    default public boolean generatesToken() {
        return false;
    }

    default public EnumSet<SearchIndex> getSearchIndexes() {
        return EnumSet.allOf(SearchIndex.class);
    }

    default public List<Index> getIndices() {
        return Collections.emptyList();
    }

    @Deprecated(forRemoval=true)
    default public ISearch withIndices(List<Index> indices) {
        return this.toBuilder().indices(indices).build();
    }

    @Deprecated(forRemoval=true)
    default public ISearch withQuery(SearchQuery query) {
        return this.toBuilder().query(query).build();
    }

    @Deprecated(forRemoval=true)
    default public ISearch withLimit(int limit) {
        return this.toBuilder().limit(limit).build();
    }

    public Builder<? extends ISearch> toBuilder();

    public static interface Builder<SEARCH extends ISearch> {
        default public Builder<SEARCH> indices(Index ... indices) {
            return this.indices(List.of(indices));
        }

        public Builder<SEARCH> indices(List<Index> var1);

        public Builder<SEARCH> query(SearchQuery var1);

        public Builder<SEARCH> sort(SearchSort var1);

        public Builder<SEARCH> startOffset(int var1);

        public Builder<SEARCH> limit(int var1);

        public Builder<SEARCH> generatesToken(boolean var1);

        public SEARCH build();
    }
}

