/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.sal.api.user.UserKey;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractUserQuery
implements SearchQuery {
    private final List<Parameter> parameters;

    public AbstractUserQuery(String username) {
        this(List.of(new Parameter(null, username)));
    }

    public AbstractUserQuery(@NonNull UserKey userKey) {
        this(List.of(new Parameter(userKey, null)));
    }

    public AbstractUserQuery(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Optional<String> username() {
        return this.parameters.stream().map(Parameter::getUsername).flatMap(Optional::stream).findFirst();
    }

    public Optional<UserKey> userkey() {
        return this.parameters.stream().map(Parameter::getUserKey).flatMap(Optional::stream).findFirst();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractUserQuery that = (AbstractUserQuery)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }

    public static class Parameter {
        private final UserKey userKey;
        private final String username;

        public Parameter(UserKey userKey, String username) {
            this.userKey = userKey;
            this.username = username;
        }

        public Optional<UserKey> getUserKey() {
            return Optional.ofNullable(this.userKey);
        }

        public Optional<String> getUsername() {
            return Optional.ofNullable(this.username);
        }

        public String toString() {
            return "{key=" + String.valueOf(this.userKey) + ", username='" + this.username + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter param = (Parameter)o;
            return Objects.equals(this.userKey, param.userKey) && Objects.equals(this.username, param.username);
        }

        public int hashCode() {
            return Objects.hash(this.userKey, this.username);
        }
    }
}

