/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.AbstractUserQuery;
import com.atlassian.confluence.search.v2.query.MatchNoDocsQuery;
import com.atlassian.confluence.search.v2.query.TermSetQuery;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.ConfluenceUserDao;
import com.atlassian.sal.api.user.UserKey;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ContributorQuery
extends AbstractUserQuery
implements SearchQuery {
    private static final String KEY = "contributor";
    private final ConfluenceUserDao confluenceUserDao;

    public ContributorQuery(String username, ConfluenceUserDao confluenceUserDao) {
        super(username);
        this.confluenceUserDao = confluenceUserDao;
    }

    public ContributorQuery(@NonNull UserKey userKey, ConfluenceUserDao confluenceUserDao) {
        super(userKey);
        this.confluenceUserDao = confluenceUserDao;
    }

    public ContributorQuery(List<AbstractUserQuery.Parameter> params, ConfluenceUserDao confluenceUserDao) {
        super(params);
        this.confluenceUserDao = confluenceUserDao;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public SearchQuery expand() {
        Set<String> userKeys = this.getParameters().stream().map(this::getUserKey).flatMap(Optional::stream).map(UserKey::getStringValue).collect(Collectors.toSet());
        if (userKeys.isEmpty()) {
            return MatchNoDocsQuery.getInstance();
        }
        return new TermSetQuery(SearchFieldMappings.LAST_MODIFIERS.getName(), userKeys);
    }

    private Optional<UserKey> getUserKey(AbstractUserQuery.Parameter param) {
        return param.getUserKey().or(() -> param.getUsername().map(this.confluenceUserDao::findByUsername).map(ConfluenceUser::getKey));
    }
}

