/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.AbstractUserQuery;
import com.atlassian.confluence.search.v2.query.ConstantScoreQuery;
import com.atlassian.confluence.search.v2.query.MatchNoDocsQuery;
import com.atlassian.confluence.search.v2.query.TermSetQuery;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.sal.api.user.UserKey;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CreatorQuery
extends AbstractUserQuery
implements SearchQuery {
    private static final String KEY = "creator";

    public CreatorQuery(String creator) {
        super(creator);
    }

    public CreatorQuery(@NonNull UserKey userKey) {
        super(userKey);
    }

    public CreatorQuery(List<AbstractUserQuery.Parameter> params) {
        super(params);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public SearchQuery expand() {
        Set<String> userKeys = this.getParameters().stream().map(this::getUserKey).flatMap(Optional::stream).map(UserKey::getStringValue).collect(Collectors.toSet());
        if (userKeys.isEmpty()) {
            return MatchNoDocsQuery.getInstance();
        }
        return new ConstantScoreQuery(new TermSetQuery(SearchFieldMappings.CREATOR.getName(), userKeys));
    }

    private Optional<UserKey> getUserKey(AbstractUserQuery.Parameter param) {
        return param.getUserKey().or(() -> param.getUsername().map(FindUserHelper::getUserByUsername).map(ConfluenceUser::getKey));
    }
}

