/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.QueryStringQuery;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

public class MacroStorageVersionQuery
implements SearchQuery {
    public static final String KEY = "macroStorageVersion";
    private final String macroName;
    private final int version;

    public MacroStorageVersionQuery(String macroName, int version) {
        Preconditions.checkNotNull((Object)macroName);
        this.macroName = macroName;
        this.version = version;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public List<Object> getParameters() {
        return ImmutableList.of((Object)this.macroName, (Object)this.version);
    }

    @Override
    public SearchQuery expand() {
        String searchTerm = this.version + "_" + this.macroName;
        String fieldName = SearchFieldMappings.MACRO_STORAGE_VERSION.getName();
        return new QueryStringQuery(Collections.singletonList(fieldName), searchTerm, BooleanOperator.AND);
    }

    public String getMacroName() {
        return this.macroName;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MacroStorageVersionQuery that = (MacroStorageVersionQuery)o;
        if (this.version != that.version) {
            return false;
        }
        return this.macroName.equals(that.macroName);
    }

    public int hashCode() {
        int result = this.macroName.hashCode();
        result = 31 * result + this.version;
        return result;
    }
}

