/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.internal.search.v2.lucene.LuceneTextFieldTokenizer;
import com.atlassian.confluence.internal.search.v2.lucene.analyzer.LuceneAnalyzerFactory;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ConstantScoreQuery;
import com.atlassian.confluence.search.v2.query.PrefixQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.atlassian.spring.container.ContainerManager;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class UserInfoQuery
implements SearchQuery {
    private static final String KEY = "userInfo";
    private final String queryString;

    public UserInfoQuery(String queryString) {
        this.queryString = queryString;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public List getParameters() {
        return Collections.emptyList();
    }

    @Override
    public SearchQuery expand() {
        BooleanQuery.Builder queryBuilder = BooleanQuery.builder();
        queryBuilder.addMust(new TermQuery(SearchFieldMappings.TYPE.getName(), "userinfo"));
        if (this.queryString == null) {
            return queryBuilder.build();
        }
        LuceneAnalyzerFactory factory = (LuceneAnalyzerFactory)ContainerManager.getComponent((String)"luceneAnalyzerFactory", LuceneAnalyzerFactory.class);
        LuceneTextFieldTokenizer tokenizer = new LuceneTextFieldTokenizer(factory);
        new LinkedHashSet<String>(tokenizer.tokenize("", this.queryString)).forEach(query -> {
            BooleanQuery.Builder userQueryBuilder = BooleanQuery.builder();
            userQueryBuilder.addShould(new PrefixQuery(SearchFieldMappings.FULL_NAME.getName(), (String)query));
            userQueryBuilder.addShould(new PrefixQuery(SearchFieldMappings.USER_NAME.getName(), (String)query));
            userQueryBuilder.addShould(new TermQuery(SearchFieldMappings.FULL_NAME.getName(), (String)query));
            ConstantScoreQuery exactMatchUserNameQuery = new ConstantScoreQuery(new TermQuery(SearchFieldMappings.USER_NAME.getName(), (String)query), 1000.0f);
            userQueryBuilder.addShould(exactMatchUserNameQuery);
            queryBuilder.addMust(userQueryBuilder.build());
        });
        return queryBuilder.build();
    }

    public String getQueryString() {
        return this.queryString;
    }
}

