/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.score;

import com.atlassian.confluence.search.v2.score.ComposableScoreFunction;
import com.atlassian.confluence.search.v2.score.ScoreFunction;
import java.util.ArrayList;
import java.util.List;

public final class AverageScoreFunction
implements ScoreFunction {
    private List<ComposableScoreFunction> functions;
    private List<Double> weights;

    private AverageScoreFunction(Builder builder) {
        this.functions = List.copyOf(builder.functions);
        this.weights = List.copyOf(builder.weights);
    }

    public List<ComposableScoreFunction> getFunctions() {
        return this.functions;
    }

    public List<Double> getWeights() {
        return this.weights;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<ComposableScoreFunction> functions = new ArrayList<ComposableScoreFunction>();
        private final List<Double> weights = new ArrayList<Double>();

        private Builder() {
        }

        public Builder add(ComposableScoreFunction function, double weight) {
            this.functions.add(function);
            this.weights.add(weight);
            return this;
        }

        public AverageScoreFunction build() {
            return new AverageScoreFunction(this);
        }
    }
}

