/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.dmz.security.ContentPermissionTester;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.embedded.api.CrowdService;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CrowdServiceAwarePermissionTester
implements ContentPermissionTester {
    private final CrowdService crowdService;

    CrowdServiceAwarePermissionTester(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Override
    public boolean anyPermitted(Iterable<ContentPermission> permissions, @Nullable ConfluenceUser user) {
        for (ContentPermission contentPermission : permissions) {
            if (!this.isPermitted(contentPermission, user)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPermitted(ContentPermission permission, @Nullable ConfluenceUser user) {
        if (user == null) {
            return false;
        }
        if (!permission.isValid()) {
            return false;
        }
        if (permission.isUserPermission()) {
            return permission.getUserSubject().getKey().equals((Object)user.getKey());
        }
        return this.crowdService.isUserMemberOfGroup(user.getName(), permission.getGroupName());
    }
}

