/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.content.Content;
import com.atlassian.confluence.content.ContentType;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.impl.content.ContentTypeModuleResolver;
import com.atlassian.confluence.internal.accessmode.AccessModeManager;
import com.atlassian.confluence.internal.security.ServiceAccountPermissionManager;
import com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal;
import com.atlassian.confluence.security.NoPermissionDelegate;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionCheckExemptions;
import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.PermissionDelegateRegistry;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.AccessStatus;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.Hibernate;

public class DefaultPermissionManager
implements PermissionManager,
PermissionDelegateRegistry {
    private Map<String, PermissionDelegate> delegates = new HashMap<String, PermissionDelegate>();
    private PermissionCheckExemptions permissionCheckExemptions;
    private ContentTypeModuleResolver contentTypeModuleResolver;
    private ConfluenceAccessManager confluenceAccessManager;
    private AccessModeManager accessModeManager;
    private ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private ServiceAccountPermissionManager serviceAccountPermissionManager;

    @Override
    public boolean hasPermission(ConfluenceUser user, Permission permission, Object target) {
        return this.hasPermission(user, permission, target, true);
    }

    private boolean shouldSkipScopeCheck(boolean checkScopePermission) {
        boolean isJsmKbScope = this.scopesRequestCacheDelegate.isScopePermitted("JSM_KB");
        return !checkScopePermission || isJsmKbScope;
    }

    @Override
    public boolean hasPermission(ConfluenceUser user, Permission permission, Object target, boolean checkScopePermission) {
        if (target == null) {
            return false;
        }
        if (this.serviceAccountPermissionManager.hasPermission(user, permission, target)) {
            return true;
        }
        if ((this.shouldSkipScopeCheck(checkScopePermission) || this.scopesRequestCacheDelegate.hasPermission(permission, target)) && this.isExempt(user) && this.permissionAllowedInReadOnlyAccessMode(permission)) {
            return true;
        }
        return this.hasPermissionNoExemptions(user, permission, target, checkScopePermission);
    }

    @VisibleForTesting
    boolean permissionAllowedInReadOnlyAccessMode(Permission permission) {
        return !this.accessModeManager.shouldEnforceReadOnlyAccess() || !permission.isMutative();
    }

    @Override
    public boolean hasPermission(ConfluenceUser user, Permission permission, Class targetType) {
        return this.hasPermission(user, permission, targetType, true);
    }

    @Override
    public boolean hasPermission(ConfluenceUser user, Permission permission, Class targetType, boolean checkScopePermission) {
        if (!this.shouldSkipScopeCheck(checkScopePermission) && !this.scopesRequestCacheDelegate.hasPermission(permission, (Object)targetType)) {
            return false;
        }
        if (targetType == null) {
            return false;
        }
        if (!Permission.VIEW.equals(permission)) {
            throw new UnsupportedOperationException("Only Permission.VIEW is supported.");
        }
        if (this.isExempt(user)) {
            return true;
        }
        if (!this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL") && !this.canUseConfluence(user)) {
            return false;
        }
        return this.findDelegateFor(targetType).canView(user);
    }

    @Override
    public boolean hasPermissionNoExemptions(ConfluenceUser user, Permission permission, Object target) {
        return this.hasPermissionNoExemptions(user, permission, target, true);
    }

    @Override
    public boolean hasPermissionNoExemptions(ConfluenceUser user, Permission permission, Object target, boolean checkScopePermission) {
        if (!this.permissionAllowedInReadOnlyAccessMode(permission)) {
            return false;
        }
        if (!this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL") && !this.canUseConfluence(user)) {
            return false;
        }
        boolean canUserAccess = permission.checkAgainst(this.findDelegateFor(target), user, target);
        if (this.shouldSkipScopeCheck(checkScopePermission)) {
            return canUserAccess;
        }
        return this.scopesRequestCacheDelegate.hasPermission(permission, target) && canUserAccess;
    }

    @Override
    public boolean hasCreatePermission(ConfluenceUser user, Object container, Class<?> typeToCreate) {
        if (!this.scopesRequestCacheDelegate.hasPermission(Permission.EDIT, typeToCreate)) {
            return false;
        }
        if (this.accessModeManager.shouldEnforceReadOnlyAccess()) {
            return false;
        }
        if (this.isExempt(user)) {
            return true;
        }
        if (container == null || !this.canUseConfluence(user)) {
            return false;
        }
        return this.findDelegateFor(typeToCreate).canCreate(user, container);
    }

    @Override
    public boolean hasCreatePermission(ConfluenceUser user, Object container, Object objectToCreate) {
        if (!this.scopesRequestCacheDelegate.hasPermission(Permission.EDIT, objectToCreate)) {
            return false;
        }
        if (this.accessModeManager.shouldEnforceReadOnlyAccess()) {
            return false;
        }
        if (this.isExempt(user)) {
            return true;
        }
        if (container == null || !this.canUseConfluence(user)) {
            return false;
        }
        return this.findDelegateFor(objectToCreate).canCreate(user, container);
    }

    private boolean isExempt(ConfluenceUser user) {
        return this.permissionCheckExemptions.isExempt(user);
    }

    private boolean canUseConfluence(ConfluenceUser user) {
        AccessStatus accessStatus = this.confluenceAccessManager.getUserAccessStatusNoExemptions(user);
        return accessStatus.canUseConfluence();
    }

    @Override
    public <X> List<X> getPermittedEntities(ConfluenceUser user, Permission permission, List<? extends X> objects) {
        ArrayList<X> returnList = new ArrayList<X>(objects.size());
        for (X o : objects) {
            if (!this.hasPermission(user, permission, o)) continue;
            returnList.add(o);
        }
        return returnList;
    }

    @Override
    public <X> List<X> getPermittedEntities(ConfluenceUser user, Permission permission, Iterator<? extends X> objects, int maxResults) {
        ArrayList<X> returnList = new ArrayList<X>(Math.min(100, maxResults));
        while (objects.hasNext() && returnList.size() < maxResults) {
            X o = objects.next();
            if (!this.hasPermission(user, permission, o)) continue;
            returnList.add(o);
        }
        return returnList;
    }

    @Override
    public <X> List<X> getPermittedEntities(ConfluenceUser user, Permission permission, Iterator<X> entities, int maxResults, Collection<? extends PermissionManager.Criterion> otherCriteria) {
        ArrayList<X> permittedEntities = new ArrayList<X>();
        while (permittedEntities.size() <= maxResults && entities.hasNext()) {
            X originalEntity = entities.next();
            if (!this.hasPermission(user, permission, originalEntity) || !this.checkCriteria(otherCriteria, permittedEntities, originalEntity)) continue;
            permittedEntities.add(originalEntity);
        }
        return permittedEntities;
    }

    @Override
    public <X> List<X> getPermittedEntitiesNoExemptions(ConfluenceUser user, Permission permission, List<? extends X> objects) {
        ArrayList<X> returnList = new ArrayList<X>(objects.size());
        for (X o : objects) {
            if (!this.hasPermissionNoExemptions(user, permission, o)) continue;
            returnList.add(o);
        }
        return returnList;
    }

    @Override
    public <X> List<X> getPermittedEntitiesNoExemptions(ConfluenceUser user, Permission permission, Iterator<? extends X> objects, int maxResults) {
        ArrayList<X> returnList = new ArrayList<X>(Math.min(100, maxResults));
        while (objects.hasNext() && returnList.size() < maxResults) {
            X o = objects.next();
            if (!this.hasPermissionNoExemptions(user, permission, o)) continue;
            returnList.add(o);
        }
        return returnList;
    }

    @Override
    public <X> List<X> getPermittedEntitiesNoExemptions(ConfluenceUser user, Permission permission, Iterator<X> entities, int maxResults, Collection<? extends PermissionManager.Criterion> otherCriteria) {
        ArrayList<X> permittedEntities = new ArrayList<X>();
        while (permittedEntities.size() <= maxResults && entities.hasNext()) {
            X originalEntity = entities.next();
            if (!this.hasPermissionNoExemptions(user, permission, originalEntity) || !this.checkCriteria(otherCriteria, permittedEntities, originalEntity)) continue;
            permittedEntities.add(originalEntity);
        }
        return permittedEntities;
    }

    @Override
    public boolean isConfluenceAdministrator(ConfluenceUser user) {
        return this.scopesRequestCacheDelegate.hasPermission(Permission.ADMINISTER, TARGET_APPLICATION) && this.hasPermission(user, Permission.ADMINISTER, TARGET_APPLICATION);
    }

    @Override
    public boolean isSystemAdministrator(ConfluenceUser user) {
        return this.scopesRequestCacheDelegate.hasPermission(Permission.ADMINISTER, TARGET_SYSTEM) && this.hasPermission(user, Permission.ADMINISTER, TARGET_SYSTEM);
    }

    @Override
    public void withExemption(Runnable runnable) {
        this.withExemption(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public <T> T withExemption(Supplier<T> supplier) {
        if (ThreadLocalPermissionsCacheInternal.hasTemporaryPermissionExemption()) {
            return supplier.get();
        }
        ThreadLocalPermissionsCacheInternal.enableTemporaryPermissionExemption();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            ThreadLocalPermissionsCacheInternal.disableTemporaryPermissionExemption();
        }
    }

    private boolean checkCriteria(Collection<? extends PermissionManager.Criterion> criteria, List<?> alreadyChosenEntities, Object entity) {
        if (criteria.isEmpty()) {
            return true;
        }
        for (PermissionManager.Criterion criterion : criteria) {
            if (criterion.test(alreadyChosenEntities, entity)) continue;
            return false;
        }
        return true;
    }

    private PermissionDelegate findDelegateFor(Object target) {
        PermissionDelegate delegate = null;
        if (target instanceof Content) {
            target = ((Content)target).getEntity();
        }
        if (target instanceof CustomContentEntityObject) {
            String pluginModuleKey = ((CustomContentEntityObject)target).getPluginModuleKey();
            if (this.contentTypeModuleResolver != null) {
                return this.contentTypeModuleResolver.findContentType(pluginModuleKey).map(ContentType::getPermissionDelegate).orElseGet(NoPermissionDelegate::new);
            }
        } else {
            delegate = this.delegates.get(this.makeDelegatesKeyFor(target));
        }
        if (delegate == null) {
            throw new IllegalArgumentException("Could not check permissions for " + String.valueOf(target) + " no suitable delegate found.");
        }
        return delegate;
    }

    private String makeDelegatesKeyFor(Object target) {
        if (target instanceof String) {
            return (String)target;
        }
        if (target instanceof Class) {
            return this.getClassNameOnly((Class)target);
        }
        return this.getClassNameOnly(Hibernate.getClass((Object)target));
    }

    private String getClassNameOnly(Class<?> clazz) {
        if (User.class.isAssignableFrom(clazz)) {
            return "User";
        }
        if (Group.class.isAssignableFrom(clazz)) {
            return "Group";
        }
        return clazz.getSimpleName();
    }

    public void setPermissionCheckExemptions(PermissionCheckExemptions permissionCheckExemptions) {
        this.permissionCheckExemptions = permissionCheckExemptions;
    }

    public void setContentTypeModuleResolver(ContentTypeModuleResolver contentTypeModuleResolver) {
        this.contentTypeModuleResolver = contentTypeModuleResolver;
    }

    public void setConfluenceAccessManager(ConfluenceAccessManager confluenceAccessManager) {
        this.confluenceAccessManager = confluenceAccessManager;
    }

    public void setAccessModeManager(AccessModeManager accessModeManager) {
        this.accessModeManager = accessModeManager;
    }

    public void setScopesRequestCacheDelegate(ScopesRequestCacheDelegate scopesRequestCache) {
        this.scopesRequestCacheDelegate = scopesRequestCache;
    }

    @Override
    public boolean hasMovePermission(ConfluenceUser user, Object source, Object target, String movePoint) {
        if (!this.scopesRequestCacheDelegate.hasPermission(Permission.EDIT, source)) {
            return false;
        }
        if (this.accessModeManager.shouldEnforceReadOnlyAccess()) {
            return false;
        }
        if (this.isExempt(user)) {
            return true;
        }
        if (!this.canUseConfluence(user)) {
            return false;
        }
        return this.findDelegateFor(source).canMove(user, source, target, movePoint);
    }

    @Override
    public boolean hasRemoveHierarchyPermission(ConfluenceUser user, Object target) {
        if (!this.scopesRequestCacheDelegate.hasPermission(Permission.REMOVE, target)) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (this.accessModeManager.shouldEnforceReadOnlyAccess()) {
            return false;
        }
        if (this.isExempt(user)) {
            return true;
        }
        if (!this.canUseConfluence(user)) {
            return false;
        }
        return this.findDelegateFor(target).canRemoveHierarchy(user, target);
    }

    @Override
    public void register(String key, PermissionDelegate<?> delegate) {
        this.delegates.put(key, delegate);
    }

    public void setServiceAccountPermissionManager(ServiceAccountPermissionManager serviceAccountPermissionManager) {
        this.serviceAccountPermissionManager = serviceAccountPermissionManager;
    }
}

