/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.access;

import com.atlassian.confluence.impl.security.recovery.RecoveryUtil;
import com.atlassian.confluence.security.PermissionCheckExemptions;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.access.AbstractConfluenceAccessManager;
import com.atlassian.confluence.security.access.AccessStatus;
import com.atlassian.confluence.security.access.AccessStatusImpl;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.DisabledUserManager;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfluenceAccessManager
extends AbstractConfluenceAccessManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfluenceAccessManager.class);
    private final DisabledUserManager disabledUserManager;
    private Supplier<AccessManagerPermissionChecker> globalPermissionChecker = () -> {
        throw new UnsupportedOperationException();
    };

    DefaultConfluenceAccessManager(DisabledUserManager disabledUserManager, PermissionCheckExemptions permissionCheckExemptions) {
        super(permissionCheckExemptions);
        this.disabledUserManager = disabledUserManager;
    }

    @Deprecated(forRemoval=true)
    public DefaultConfluenceAccessManager(DisabledUserManager disabledUserManager, PermissionCheckExemptions permissionCheckExemptions, Supplier<AccessManagerPermissionChecker> globalPermissionChecker) {
        super(permissionCheckExemptions);
        this.disabledUserManager = disabledUserManager;
        this.globalPermissionChecker = globalPermissionChecker;
    }

    @Override
    public @NonNull AccessStatus getUserAccessStatusNoExemptions(@Nullable ConfluenceUser user) {
        if (this.isDisabled(user)) {
            return AccessStatusImpl.NOT_PERMITTED;
        }
        if (user == null) {
            return this.getAccessStatusForAnonymous();
        }
        if (user.isServiceAccount()) {
            return AccessStatusImpl.LICENSED_ACCESS;
        }
        return this.getAccessStatusForLoggedInUser(user);
    }

    private boolean isDisabled(ConfluenceUser user) {
        return this.disabledUserManager.isDisabled(user);
    }

    private AccessStatus getAccessStatusForAnonymous() {
        if (this.anonymousCanUseConfluence()) {
            log.debug("Anonymous user has USE permission because anonymous users have been granted this permission - ANONYMOUS_ACCESS");
            return AccessStatusImpl.ANONYMOUS_ACCESS;
        }
        log.debug("User is anonymous and USE Confluence permission not granted to anonymous users - NOT_PERMITTED");
        return AccessStatusImpl.NOT_PERMITTED;
    }

    private AccessStatus getAccessStatusForLoggedInUser(@NonNull ConfluenceUser user) {
        if (RecoveryUtil.isRecoveryAdmin(user)) {
            return AccessStatusImpl.LICENSED_ACCESS;
        }
        if (this.getGlobalPermissionChecker().hasGlobalPermissionViaGroups(user, "USECONFLUENCE")) {
            log.debug("User {} has USE permission via group - LICENSED_ACCESS", (Object)user.getName());
            return AccessStatusImpl.LICENSED_ACCESS;
        }
        if (this.hasGlobalPermissionAsUser(user, "USECONFLUENCE")) {
            log.debug("User {} has USE permission directly as individual - LICENSED_ACCESS", (Object)user.getName());
            return AccessStatusImpl.LICENSED_ACCESS;
        }
        if (this.hasAuthenticatedUnlicensedConfluenceAccess(user)) {
            return AccessStatusImpl.UNLICENSED_AUTHENTICATED_ACCESS;
        }
        log.debug("User {} does not have access via groups or as individual user - NOT_PERMITTED", (Object)user.getName());
        return AccessStatusImpl.NOT_PERMITTED;
    }

    private boolean anonymousCanUseConfluence() {
        return this.hasGlobalPermissionAsUser(null, "USECONFLUENCE");
    }

    private boolean hasAuthenticatedUnlicensedConfluenceAccess(@NonNull ConfluenceUser user) {
        SpacePermission constructedPermission = SpacePermission.createAuthenticatedUsersSpacePermission("LIMITEDUSECONFLUENCE", null);
        if (this.getGlobalPermissionChecker().permissionExists(constructedPermission)) {
            log.debug("User {} has limited access to Confluence because all authenticated users have been granted LIMITED_USE_CONFLUENCE_PERMISSION - UNLICENSED_AUTHENTICATED_ACCESS", (Object)user.getName());
            return true;
        }
        return false;
    }

    private boolean hasGlobalPermissionAsUser(@Nullable ConfluenceUser user, @NonNull String permissionType) {
        SpacePermission constructedPermission = user == null ? SpacePermission.createAnonymousSpacePermission(permissionType, null) : SpacePermission.createUserSpacePermission(permissionType, null, user);
        return this.getGlobalPermissionChecker().permissionExists(constructedPermission);
    }

    protected AccessManagerPermissionChecker getGlobalPermissionChecker() {
        return this.globalPermissionChecker.get();
    }

    public static interface AccessManagerPermissionChecker {
        public boolean permissionExists(SpacePermission var1);

        public boolean hasGlobalPermissionViaGroups(@NonNull ConfluenceUser var1, String var2);
    }
}

