/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.actions;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.json.SingleErrorJSONResult;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AuthenticationHelper;
import com.atlassian.confluence.user.actions.LoginAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class NotPermittedAction
extends LoginAction
implements Beanable {
    private static final Set<String> JSON_CONTENT_TYPES = Set.of("application/json", "application/javascript", "text/javascript");
    private static final Logger log = LoggerFactory.getLogger(NotPermittedAction.class);
    private String key;
    private String title;
    private String message;
    private String cssClass;
    private SpaceManager spaceManager;
    private Object jsonResult;

    @Override
    @PermittedMethods(value={HttpMethod.ANY_METHOD})
    @XsrfProtectionExcluded
    public String execute() throws Exception {
        this.setFromNotPermitted(true);
        if (!StringUtils.isNotEmpty((CharSequence)((String)this.getActiveRequest().getAttribute("atlassian.core.seraph.original.url")))) {
            String originalURL = GeneralUtil.getRequestUrl(this.getActiveRequest());
            this.getActiveRequest().setAttribute("atlassian.core.seraph.original.url", (Object)originalURL);
            if (log.isDebugEnabled()) {
                log.debug("No atlassian.core.seraph.original.url was found in the request. Storing {}", (Object)originalURL);
            }
        }
        if (this.getAuthenticatedUser() == null) {
            if (this.isJsonRequest(this.getActiveRequest())) {
                this.getActiveResponse().setStatus(401);
                this.jsonResult = new SingleErrorJSONResult("json.not.logged.in", new Object[]{SeraphUtils.getLinkLoginURL(this.getActiveRequest())});
                return "json";
            }
            return "login";
        }
        if (this.isJsonRequest(this.getActiveRequest())) {
            this.getActiveResponse().setStatus(403);
            this.jsonResult = new SingleErrorJSONResult("not.permitted.description");
            return "json";
        }
        this.title = this.getText("title.not.permitted");
        this.message = this.getText("not.permitted.description");
        this.cssClass = "not-permitted-background-image";
        return "success";
    }

    private boolean isJsonRequest(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader != null) {
            for (String contentType : JSON_CONTENT_TYPES) {
                if (!acceptHeader.contains(contentType)) continue;
                return true;
            }
        }
        return request.getServletPath().startsWith("/json");
    }

    public String getLoginUrl() {
        return AuthenticationHelper.getLoginUrl();
    }

    public String getKey() {
        return this.key;
    }

    @StrutsParameter
    public void setKey(String key) {
        this.key = key;
    }

    public Space getSpace() {
        return this.spaceManager.getSpace(this.getKey());
    }

    @Override
    public String getUsername() {
        if (this.getSpace() != null && this.getSpace().getCreator() != null) {
            ConfluenceUser user = this.getSpace().getCreator();
            return user.getFullName();
        }
        return null;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    @Override
    public Object getBean() {
        return this.jsonResult;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCssClass() {
        return this.cssClass;
    }
}

