/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.actions;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.dmz.struts.MappedAction;
import com.atlassian.confluence.internal.accessmode.ThreadLocalReadOnlyAccessCacheInternal;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.config.entities.ActionConfig;
import org.apache.struts2.interceptor.Interceptor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionCheckInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(PermissionCheckInterceptor.class);
    public static final String NOT_PERMITTED = "notpermitted";
    private static final String NOT_PERMITTED_PERSONAL_SPACE = "notpermittedpersonal";
    public static final String PAGE_NOT_PERMITTED = "pagenotpermitted";
    public static final String NOT_FOUND = "notfound";
    public static final String READ_ONLY = "readonly";
    private static final Set<HttpMethod> MUTATIVE_HTTP_METHODS = Set.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE);
    private static final String READ_ONLY_ACCESS_ALLOWED_ANNOTATION = "ReadOnlyAccessAllowed";
    private static final String READ_ONLY_ACCESS_BLOCKED_ANNOTATION = "ReadOnlyAccessBlocked";
    private static final Supplier<AccessModeService> accessModeServiceRef = MemoizingComponentReference.containerComponent("accessModeService");

    public void destroy() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        Object action = actionInvocation.getAction();
        Class<?> actionClass = action.getClass();
        Package actionClassPackage = actionClass.getPackage();
        try {
            if (this.isReadOnlyAccessModeEnabled()) {
                if (this.isReadOnlyAccessBlocked(actionInvocation, actionClassPackage, actionClass)) {
                    String string = READ_ONLY;
                    return string;
                }
                if (this.isReadOnlyAccessAllowed(actionInvocation, actionClassPackage, actionClass)) {
                    ThreadLocalReadOnlyAccessCacheInternal.enableReadOnlyAccessExemption();
                }
            }
            if (!(action instanceof ConfluenceActionSupport)) {
                String string = actionInvocation.invoke();
                return string;
            }
            ConfluenceActionSupport confluenceAction = (ConfluenceActionSupport)action;
            if (!confluenceAction.isPermitted()) {
                log.debug("Not permitted to execute action of class {} ", confluenceAction.getClass());
                String reqMethod = actionInvocation.getInvocationContext().getServletRequest().getMethod();
                if (this.isReadOnlyAccessModeEnabled() && this.isMutativeHttpMethod(reqMethod) && !ThreadLocalReadOnlyAccessCacheInternal.hasReadOnlyAccessExemption()) {
                    String string = READ_ONLY;
                    return string;
                }
                String string = this.isPersonalSpaceAction(confluenceAction) ? NOT_PERMITTED_PERSONAL_SPACE : NOT_PERMITTED;
                return string;
            }
            String string = actionInvocation.invoke();
            return string;
        }
        finally {
            ThreadLocalReadOnlyAccessCacheInternal.disableReadOnlyAccessExemption();
        }
    }

    private boolean isReadOnlyAccessModeEnabled() {
        return ContainerManager.isContainerSetup() && accessModeServiceRef.get().isReadOnlyAccessModeEnabled();
    }

    private boolean isPersonalSpaceAction(ConfluenceActionSupport confluenceAction) {
        return confluenceAction instanceof Spaced && ((Spaced)((Object)confluenceAction)).getSpace() != null && ((Spaced)((Object)confluenceAction)).getSpace().isPersonal();
    }

    private boolean isReadOnlyAccessBlocked(ActionInvocation actionInvocation, Package actionClassPackage, Class<?> actionClass) {
        return this.isAnnotated(actionClassPackage, READ_ONLY_ACCESS_BLOCKED_ANNOTATION) || this.isAnnotated(actionClass, READ_ONLY_ACCESS_BLOCKED_ANNOTATION) || this.isAnnotated(this.getMethod(actionInvocation, actionClass), READ_ONLY_ACCESS_BLOCKED_ANNOTATION);
    }

    private boolean isReadOnlyAccessAllowed(ActionInvocation actionInvocation, Package actionClassPackage, Class<?> actionClass) {
        Method method = this.getMethod(actionInvocation, actionClass);
        return StringUtils.startsWith((CharSequence)actionInvocation.getProxy().getNamespace(), (CharSequence)"/admin") || this.isAnnotated(actionClassPackage, READ_ONLY_ACCESS_ALLOWED_ANNOTATION) || this.isAnnotated(actionClass, READ_ONLY_ACCESS_ALLOWED_ANNOTATION) || this.isAnnotated(method, READ_ONLY_ACCESS_ALLOWED_ANNOTATION);
    }

    private Method getMethod(ActionInvocation actionInvocation, Class<?> actionClass) {
        ActionConfig actionConfig = actionInvocation.getProxy().getConfig();
        return MappedAction.getActionClassMethod(actionClass, actionConfig.getMethodName());
    }

    private boolean isMutativeHttpMethod(String currentHttpMethod) {
        return MUTATIVE_HTTP_METHODS.stream().anyMatch(method -> method.matches(currentHttpMethod));
    }

    private boolean isAnnotated(@NonNull AnnotatedElement annotatedElement, @NonNull String simpleAnnotationName) {
        Annotation[] annotations = annotatedElement.getDeclaredAnnotations();
        if (annotations == null) {
            return false;
        }
        return Arrays.stream(annotations).anyMatch(annotation -> simpleAnnotationName.equals(annotation.annotationType().getSimpleName()));
    }
}

