/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.administrators;

import com.atlassian.confluence.security.actions.PermissionRow;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Group;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class DefaultPermissionsAdministrator {

    public static class UnlicensedPermissionRow
    extends PermissionRow {
        private final String category;

        public static UnlicensedPermissionRow makeUnlicensedAuthenticatedUsersRow() {
            return new UnlicensedPermissionRow("authenticatedusers");
        }

        public static UnlicensedPermissionRow makeAnonymousRow() {
            return new UnlicensedPermissionRow("anonymous");
        }

        private UnlicensedPermissionRow(String category) {
            this.category = category;
        }

        @Override
        public String buildParameterName(String permissionType, String inputType) {
            StringBuilder result = new StringBuilder("confluence_").append(inputType).append("_");
            result.append(permissionType.toLowerCase(Locale.ENGLISH)).append("_");
            result.append(this.category);
            return result.toString();
        }

        @Override
        public boolean entityExists() {
            return true;
        }

        @Override
        public boolean isCaseInvalid() {
            return false;
        }
    }

    public static class GroupPermissionRow
    extends PermissionRow {
        private final String groupName;
        private final Group group;

        public GroupPermissionRow(String permissionGroupName, Group group) {
            this.groupName = permissionGroupName;
            this.group = group;
        }

        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public String buildParameterName(String permissionType, String inputType) {
            StringBuilder result = new StringBuilder("confluence_").append(inputType).append("_");
            result.append(permissionType.toLowerCase(Locale.ENGLISH)).append("_");
            result.append("group_").append(this.groupName);
            return result.toString();
        }

        @Override
        public boolean entityExists() {
            return this.group != null;
        }

        @Override
        public boolean isCaseInvalid() {
            return this.group != null && !this.group.getName().equals(this.groupName);
        }

        public Group getGroup() {
            return this.group;
        }
    }

    public static class UserPermissionRow
    extends PermissionRow {
        private final ConfluenceUser user;

        public UserPermissionRow(ConfluenceUser user) {
            this.user = user;
        }

        public String getUsername() {
            return this.user.getName();
        }

        public String getUserKey() {
            return this.user.getKey().getStringValue();
        }

        @Override
        public String buildParameterName(String permissionType, String inputType) {
            return StringUtils.join((Object[])new String[]{"confluence_", inputType, "_", permissionType.toLowerCase(Locale.ENGLISH), "_", "user", "_", this.user.getKey().getStringValue()});
        }

        @Override
        public boolean entityExists() {
            return this.user != null;
        }

        @Override
        public boolean isCaseInvalid() {
            return false;
        }

        public ConfluenceUser getUser() {
            return this.user;
        }
    }
}

