/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;

public class ApplicationPermissionsDelegate
implements PermissionDelegate {
    private SpacePermissionManager spacePermissionManager;

    public boolean canView(ConfluenceUser user, Object target) {
        return this.spacePermissionManager.hasPermissionNoExemptions("USECONFLUENCE", null, user);
    }

    @Override
    public boolean canView(ConfluenceUser user) {
        throw new UnsupportedOperationException();
    }

    public boolean canEdit(ConfluenceUser user, Object target) {
        throw new IllegalStateException("Edit permission does not apply on the application level.");
    }

    public boolean canSetPermissions(ConfluenceUser user, Object target) {
        return this.spacePermissionManager.hasPermissionNoExemptions("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermissionNoExemptions("SYSTEMADMINISTRATOR", null, user);
    }

    public boolean canRemove(ConfluenceUser user, Object target) {
        throw new IllegalStateException("Remove permission does not apply on the application level.");
    }

    public boolean canExport(ConfluenceUser user, Object target) {
        return this.spacePermissionManager.hasPermissionNoExemptions("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermissionNoExemptions("SYSTEMADMINISTRATOR", null, user);
    }

    public boolean canAdminister(ConfluenceUser user, Object target) {
        return this.spacePermissionManager.hasPermissionNoExemptions("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermissionNoExemptions("SYSTEMADMINISTRATOR", null, user);
    }

    @Override
    public boolean canCreate(ConfluenceUser user, Object container) {
        throw new IllegalStateException("Create permission does not apply on the application level.");
    }

    @Override
    public boolean canCreateInTarget(ConfluenceUser user, Class typeToCreate) {
        throw new UnsupportedOperationException();
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }
}

