/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.GlobalDescription;
import com.atlassian.confluence.user.ConfluenceUser;

public class GlobalDescriptionPermissionsDelegate
implements PermissionDelegate<GlobalDescription> {
    private SpacePermissionManager spacePermissionManager;

    @Override
    public boolean canAdminister(ConfluenceUser user, GlobalDescription target) {
        return this.isApplicationAdminOrSysAdmin(user);
    }

    @Override
    public boolean canCreate(ConfluenceUser user, Object container) {
        return this.isApplicationAdminOrSysAdmin(user);
    }

    @Override
    public boolean canCreateInTarget(ConfluenceUser user, Class typeToCreate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canEdit(ConfluenceUser user, GlobalDescription target) {
        return this.isApplicationAdminOrSysAdmin(user);
    }

    @Override
    public boolean canExport(ConfluenceUser user, GlobalDescription target) {
        return this.isApplicationAdminOrSysAdmin(user);
    }

    @Override
    public boolean canRemove(ConfluenceUser user, GlobalDescription target) {
        return this.isApplicationAdminOrSysAdmin(user);
    }

    @Override
    public boolean canSetPermissions(ConfluenceUser user, GlobalDescription target) {
        return this.isApplicationAdminOrSysAdmin(user);
    }

    @Override
    public boolean canView(ConfluenceUser user, GlobalDescription target) {
        return true;
    }

    @Override
    public boolean canView(ConfluenceUser user) {
        throw new UnsupportedOperationException();
    }

    private boolean isApplicationAdminOrSysAdmin(ConfluenceUser user) {
        return this.spacePermissionManager.hasPermissionNoExemptions("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermissionNoExemptions("SYSTEMADMINISTRATOR", null, user);
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }
}

