/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Group;

public class GroupPermissionsDelegate
implements PermissionDelegate<Group> {
    private SpacePermissionManager spacePermissionManager;
    private UserAccessor userAccessor;

    @Override
    public boolean canView(ConfluenceUser user, Group target) {
        return this.isUserConfluenceOrSystemAdmin(user) || this.spacePermissionManager.hasPermission("BROWSEALLGROUPMEMBERS", null, user) || this.userAccessor.hasMembership(target, user);
    }

    @Override
    public boolean canView(ConfluenceUser user) {
        return this.isUserConfluenceOrSystemAdmin(user) || this.spacePermissionManager.hasPermission("BROWSEALLGROUPMEMBERS", null, user);
    }

    @Override
    public boolean canEdit(ConfluenceUser user, Group group) {
        return this.hasRelevantAdministrativePermission(user, group);
    }

    @Override
    public boolean canRemove(ConfluenceUser user, Group target) {
        return this.hasRelevantAdministrativePermission(user, target);
    }

    @Override
    public boolean canCreate(ConfluenceUser user, Object container) {
        return this.isUserConfluenceOrSystemAdmin(user);
    }

    @Override
    public boolean canCreateInTarget(ConfluenceUser user, Class typeToCreate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canExport(ConfluenceUser user, Group target) {
        throw new UnsupportedOperationException("Export privileges is undefined for groups and hence does not apply.");
    }

    @Override
    public boolean canSetPermissions(ConfluenceUser user, Group target) {
        return this.hasRelevantAdministrativePermission(user, target);
    }

    private boolean hasRelevantAdministrativePermission(ConfluenceUser user, Group targetGroup) {
        if (this.spacePermissionManager.groupHasPermission("SYSTEMADMINISTRATOR", null, targetGroup.getName()) || this.spacePermissionManager.groupInheritsPermission("SYSTEMADMINISTRATOR", null, targetGroup.getName()) || "confluence-administrators".equals(targetGroup.getName())) {
            return this.spacePermissionManager.hasPermissionNoExemptions("SYSTEMADMINISTRATOR", null, user);
        }
        return this.isUserConfluenceOrSystemAdmin(user);
    }

    private boolean isUserConfluenceOrSystemAdmin(ConfluenceUser user) {
        return this.spacePermissionManager.hasPermissionNoExemptions("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermissionNoExemptions("SYSTEMADMINISTRATOR", null, user);
    }

    @Override
    public boolean canAdminister(ConfluenceUser user, Group target) {
        throw new UnsupportedOperationException("Administer privileges is undefined for groups and hence does not apply.");
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

