/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.links.AbstractLink;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;

public class LinkPermissionsDelegate
implements PermissionDelegate<AbstractLink> {
    private PermissionManager permissionManager;

    @Override
    public boolean canView(ConfluenceUser user, AbstractLink target) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, this.getContent(target));
    }

    @Override
    public boolean canView(ConfluenceUser user) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canEdit(ConfluenceUser user, AbstractLink target) {
        throw new UnsupportedOperationException("Links do not support edit permissions");
    }

    @Override
    public boolean canSetPermissions(ConfluenceUser user, AbstractLink target) {
        throw new UnsupportedOperationException("Links do not support permission-setting permissions");
    }

    @Override
    public boolean canRemove(ConfluenceUser user, AbstractLink target) {
        throw new UnsupportedOperationException("Links do not support remove permissions");
    }

    @Override
    public boolean canExport(ConfluenceUser user, AbstractLink target) {
        throw new UnsupportedOperationException("Links do not support export permissions");
    }

    @Override
    public boolean canAdminister(ConfluenceUser user, AbstractLink target) {
        throw new UnsupportedOperationException("Links do not support administer permissions");
    }

    @Override
    public boolean canCreate(ConfluenceUser user, Object container) {
        throw new UnsupportedOperationException("Links do not support create permissions");
    }

    @Override
    public boolean canCreateInTarget(ConfluenceUser user, Class typeToCreate) {
        throw new UnsupportedOperationException("Links do not support create permissions. Type received: " + String.valueOf(typeToCreate));
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    private Object getContent(AbstractLink target) {
        return target.getSourceContent();
    }
}

