/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.delegate.AbstractPermissionsDelegate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagePermissionsDelegate
extends AbstractPermissionsDelegate<Page> {
    private ContentPermissionManager contentPermissionManager;
    private static final Logger log = LoggerFactory.getLogger(PagePermissionsDelegate.class);

    @Override
    public boolean canView(ConfluenceUser user, Page target) {
        if (target.isDraft()) {
            return this.hasSpaceLevelPermission("VIEWSPACE", user, target) && this.hasContentLevelEditPermission(user, target);
        }
        return this.hasSpaceLevelPermission("VIEWSPACE", user, target) && this.hasContentLevelViewPermission(user, target);
    }

    @Override
    public boolean canEdit(ConfluenceUser user, Page target) {
        return this.hasSpaceLevelPermission("VIEWSPACE", user, target) && this.hasSpaceLevelPermission("EDITSPACE", user, target) && this.hasContentLevelEditPermission(user, target);
    }

    @Override
    public boolean canSetPermissions(ConfluenceUser user, Page target) {
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target) || this.canEdit(user, target) && this.hasSpaceLevelPermission("SETPAGEPERMISSIONS", user, target);
    }

    @Override
    public boolean canRemove(ConfluenceUser user, Page target) {
        if (!this.hasSpaceLevelPermission("REMOVEPAGE", user, target) && !this.canRemoveOwn(target, user)) {
            return false;
        }
        if (!this.canView(user, target)) {
            return false;
        }
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target) || this.hasContentLevelEditPermission(user, target);
    }

    @Override
    public boolean canMove(ConfluenceUser user, Page source, Object target, String movePoint) {
        if (target != null && !(target instanceof Page) && !(target instanceof Space)) {
            log.error("Target should be either a space or page");
            return false;
        }
        boolean canEdit = this.canEdit(user, source);
        Page targetPage = null;
        Space targetSpace = null;
        if (target instanceof Page) {
            targetPage = (Page)target;
            targetSpace = targetPage.getSpace();
        }
        if (target instanceof Space) {
            targetSpace = (Space)target;
        }
        boolean canCreateInSpace = this.canCreate(user, targetSpace);
        if (canEdit && canCreateInSpace) {
            if (!(source.isDraft() || targetSpace.equals(source.getSpace()) || this.canRemoveHierarchy(user, source))) {
                return false;
            }
            if ("below".equals(movePoint) || "above".equals(movePoint)) {
                if (targetPage.getParent() != null) {
                    return this.hasContentLevelViewPermission(user, targetPage.getParent());
                }
                return true;
            }
            if ("append".equals(movePoint)) {
                return this.hasContentLevelViewPermission(user, targetPage);
            }
            if ("topLevel".equals(movePoint)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canRemoveHierarchy(ConfluenceUser user, Page target) {
        if (!this.canView(user, target)) {
            return false;
        }
        if (!this.hasSpaceLevelPermission("REMOVEPAGE", user, target)) {
            if (!this.canRemoveOwn(target, user)) {
                return false;
            }
            for (Page page : target.getChildren()) {
                if (this.canRemoveOwn(page, user) && this.canRemoveHierarchy(user, page)) continue;
                return false;
            }
        }
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target) || this.hasContentLevelEditPermission(user, target);
    }

    private boolean canRemoveOwn(Object target, ConfluenceUser user) {
        Page page = (Page)target;
        boolean isCreator = page != null && page.getCreator() != null && user != null && user.getName() != null && user.getName().equals(page.getCreator().getName());
        return isCreator && this.hasSpaceLevelPermission("REMOVEOWNCONTENT", user, target);
    }

    @Override
    public boolean canExport(ConfluenceUser user, Page target) {
        return this.canView(user, target) && this.hasContentLevelExportPermission(user, target);
    }

    @Override
    public boolean canAdminister(ConfluenceUser user, Page target) {
        throw new IllegalStateException("Administration privileges do not apply to pages");
    }

    private boolean hasContentLevelExportPermission(ConfluenceUser user, Object target) {
        return this.contentPermissionManager.hasContentLevelPermission(user, "Export", (ContentEntityObject)target);
    }

    private boolean hasContentLevelViewPermission(ConfluenceUser user, Object target) {
        return this.contentPermissionManager.hasContentLevelPermission(user, "View", (ContentEntityObject)target);
    }

    private boolean hasContentLevelEditPermission(ConfluenceUser user, Object target) {
        return this.contentPermissionManager.hasContentLevelPermission(user, "Edit", (ContentEntityObject)target);
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    @Override
    public boolean canCreate(ConfluenceUser user, Object container) {
        return this.spacePermissionManager.hasPermissionNoExemptions("VIEWSPACE", (Space)container, user) && this.spacePermissionManager.hasPermissionNoExemptions("EDITSPACE", (Space)container, user);
    }

    @Override
    protected Space getSpaceFrom(Object target) {
        return ((AbstractPage)target).getSpace();
    }
}

