/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.security.delegate.AbstractPermissionsDelegate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.confluence.user.ConfluenceUser;

public class PageTemplatePermissionsDelegate
extends AbstractPermissionsDelegate<PageTemplate> {
    @Override
    public boolean canView(ConfluenceUser user, PageTemplate target) {
        return this.hasSpaceLevelPermission("VIEWSPACE", user, target);
    }

    @Override
    public boolean canEdit(ConfluenceUser user, PageTemplate target) {
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    @Override
    public boolean canSetPermissions(ConfluenceUser user, PageTemplate target) {
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    @Override
    public boolean canRemove(ConfluenceUser user, PageTemplate target) {
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    @Override
    public boolean canExport(ConfluenceUser user, PageTemplate target) {
        return this.hasSpaceLevelPermission("EXPORTSPACE", user, target);
    }

    @Override
    public boolean canAdminister(ConfluenceUser user, PageTemplate target) {
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    @Override
    public boolean canCreate(ConfluenceUser user, Object container) {
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, container);
    }

    @Override
    protected Space getSpaceFrom(Object target) {
        if (target instanceof PageTemplate) {
            return ((PageTemplate)target).getSpace();
        }
        if (target instanceof Space) {
            return (Space)target;
        }
        if (target instanceof Spaced) {
            return ((Spaced)target).getSpace();
        }
        throw new IllegalArgumentException("Unsupported target for page template permission check: " + String.valueOf(target.getClass()));
    }
}

