/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.function.BiPredicate;

public class SharedAccessInterceptor
implements PermissionDelegate {
    private final PermissionDelegate delegate;
    private final BiPredicate<ConfluenceUser, ContentEntityObject> sharedAccessCheck;

    public SharedAccessInterceptor(PermissionDelegate<?> delegate, ContentPermissionManager contentPermissionManager) {
        this.delegate = delegate;
        this.sharedAccessCheck = contentPermissionManager::isSharedAccessAllowed;
    }

    public boolean canView(ConfluenceUser user, Object target) {
        return this.checkAccess(user, target, this.delegate::canView);
    }

    @Override
    public boolean canView(ConfluenceUser user) {
        return this.delegate.canView(user);
    }

    public boolean canEdit(ConfluenceUser user, Object target) {
        return this.checkAccess(user, target, this.delegate::canEdit);
    }

    public boolean canSetPermissions(ConfluenceUser user, Object target) {
        return this.checkAccess(user, target, this.delegate::canSetPermissions);
    }

    public boolean canRemove(ConfluenceUser user, Object target) {
        return this.checkAccess(user, target, this.delegate::canRemove);
    }

    public boolean canRemoveHierarchy(ConfluenceUser user, Object target) {
        return this.delegate.canRemoveHierarchy(user, target);
    }

    public boolean canMove(ConfluenceUser user, Object source, Object target, String movePoint) {
        return this.delegate.canMove(user, source, target, movePoint);
    }

    public boolean canExport(ConfluenceUser user, Object target) {
        return this.checkAccess(user, target, this.delegate::canExport);
    }

    public boolean canAdminister(ConfluenceUser user, Object target) {
        return this.delegate.canAdminister(user, target);
    }

    @Override
    public boolean canCreate(ConfluenceUser user, Object container) {
        return this.delegate.canCreate(user, container);
    }

    @Override
    public boolean canCreateInTarget(ConfluenceUser user, Class typeToCreate) {
        return this.delegate.canCreateInTarget(user, typeToCreate);
    }

    private boolean checkAccess(ConfluenceUser user, Object target, BiPredicate<ConfluenceUser, Object> permissionsCheck) {
        ContentEntityObject ceo;
        if (target instanceof ContentEntityObject && !this.sharedAccessCheck.test(user, ceo = (ContentEntityObject)target)) {
            return false;
        }
        return permissionsCheck.test(user, target);
    }
}

