/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.delegate.AbstractPermissionsDelegate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;

public class SpacePermissionsDelegate
extends AbstractPermissionsDelegate<Space> {
    @Override
    public boolean canView(ConfluenceUser user, Space target) {
        return this.hasSpaceLevelPermission("VIEWSPACE", user, target);
    }

    @Override
    public boolean canEdit(ConfluenceUser user, Space target) {
        return this.canView(user, target) && this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    @Override
    public boolean canSetPermissions(ConfluenceUser user, Space target) {
        return this.canView(user, target) && this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    @Override
    public boolean canRemove(ConfluenceUser user, Space target) {
        return this.canView(user, target) && this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    @Override
    public boolean canExport(ConfluenceUser user, Space target) {
        return this.canView(user, target) && this.hasSpaceLevelPermission("EXPORTSPACE", user, target);
    }

    @Override
    public boolean canAdminister(ConfluenceUser user, Space target) {
        return this.canView(user, target) && this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    @Override
    public boolean canCreate(ConfluenceUser user, Object container) {
        if (PermissionManager.TARGET_APPLICATION.equals(container)) {
            return this.spacePermissionManager.hasPermissionNoExemptions("CREATESPACE", null, user);
        }
        if (container instanceof PersonalInformation) {
            return this.spacePermissionManager.hasPermissionNoExemptions("PERSONALSPACE", null, user);
        }
        throw new IllegalArgumentException("Can only create spaces within the application, or for a user");
    }

    @Override
    protected Space getSpaceFrom(Object target) {
        return (Space)target;
    }
}

