/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.user.User;

public class UserPermissionsDelegate
implements PermissionDelegate<User> {
    private SpacePermissionManager spacePermissionManager;
    private ConfluenceAccessManager confluenceAccessManager;

    @Override
    public boolean canView(ConfluenceUser user, User target) {
        return target != null && target.equals((Object)user) || this.canView(user);
    }

    @Override
    public boolean canView(ConfluenceUser user) {
        if (this.shouldCheckBrowseUsersPermission(user)) {
            return this.spacePermissionManager.hasPermissionNoExemptions("VIEWUSERPROFILES", null, user);
        }
        return true;
    }

    private boolean shouldCheckBrowseUsersPermission(ConfluenceUser user) {
        return this.isAnonymous(user) || !this.confluenceAccessManager.getUserAccessStatus(user).hasLicensedAccess();
    }

    @Override
    public boolean canEdit(ConfluenceUser user, User target) {
        if (this.isAnonymous(user)) {
            return false;
        }
        if (target.getName().equals(user.getName())) {
            return true;
        }
        return this.hasRelevantAdministrativePermissions(user, target);
    }

    @Override
    public boolean canRemove(ConfluenceUser user, User target) {
        if (this.isAnonymous(user)) {
            return false;
        }
        return this.hasRelevantAdministrativePermissions(user, target);
    }

    @Override
    public boolean canCreate(ConfluenceUser user, Object container) {
        if (this.isAnonymous(user)) {
            return false;
        }
        return this.spacePermissionManager.hasPermissionNoExemptions("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermissionNoExemptions("SYSTEMADMINISTRATOR", null, user);
    }

    @Override
    public boolean canCreateInTarget(ConfluenceUser user, Class typeToCreate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canExport(ConfluenceUser user, User target) {
        throw new UnsupportedOperationException("Export privileges do not apply to users");
    }

    @Override
    public boolean canSetPermissions(ConfluenceUser user, User target) {
        return this.hasRelevantAdministrativePermissions(user, target);
    }

    @Override
    public boolean canAdminister(ConfluenceUser user, User target) {
        throw new UnsupportedOperationException("Administer privileges is undefined for users and hence does not apply.");
    }

    private boolean hasRelevantAdministrativePermissions(ConfluenceUser user, User targetUser) {
        if (this.spacePermissionManager.hasPermissionNoExemptions("SYSTEMADMINISTRATOR", null, FindUserHelper.getUser(targetUser))) {
            return this.spacePermissionManager.hasPermissionNoExemptions("SYSTEMADMINISTRATOR", null, user);
        }
        return this.spacePermissionManager.hasPermissionNoExemptions("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermissionNoExemptions("SYSTEMADMINISTRATOR", null, user);
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setConfluenceAccessManager(ConfluenceAccessManager confluenceAccessManager) {
        this.confluenceAccessManager = confluenceAccessManager;
    }

    private boolean isAnonymous(ConfluenceUser user) {
        return user == null;
    }
}

