/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.denormalisedpermissions.impl;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.event.events.admin.SiteDarkFeatureDisabledEvent;
import com.atlassian.confluence.event.events.admin.SiteDarkFeatureEnabledEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.event.events.lifecycle.ApplicationStartedEvent;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterEventListeners
@Internal
public final class DenormalisedPermissionDarkFeature {
    private static final Logger log = LoggerFactory.getLogger(DenormalisedPermissionDarkFeature.class);
    private static final String FEATURE_KEY = "confluence.denormalisedpermissions";
    private final DarkFeatureManager darkFeatureManager;
    private final AtomicBoolean enabled = new AtomicBoolean();

    public DenormalisedPermissionDarkFeature(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    @EventListener
    public void onApplicationStarted(ApplicationStartedEvent event) {
        this.onApplicationStarted();
    }

    private void onApplicationStarted() {
        if (this.darkFeatureManager.isEnabledForAllUsers(FEATURE_KEY).orElse(false).booleanValue()) {
            this.setEnabled();
        } else {
            this.setDisabled();
        }
    }

    @EventListener
    public void onSiteDarkFeatureEnabledEvent(SiteDarkFeatureEnabledEvent event) {
        if (FEATURE_KEY.equals(event.getFeatureKey())) {
            this.setEnabled();
        }
    }

    @EventListener
    public void onSiteDarkFeatureDisabledEvent(SiteDarkFeatureDisabledEvent event) {
        if (FEATURE_KEY.equals(event.getFeatureKey())) {
            this.setDisabled();
        }
    }

    @EventListener
    public void onClusterEventWrapper(ClusterEventWrapper clusterEventWrapper) {
        ClusterEvent event = clusterEventWrapper.getEvent();
        if (event instanceof SiteDarkFeatureEnabledEvent) {
            this.onSiteDarkFeatureEnabledEvent((SiteDarkFeatureEnabledEvent)event);
        } else if (event instanceof SiteDarkFeatureDisabledEvent) {
            this.onSiteDarkFeatureDisabledEvent((SiteDarkFeatureDisabledEvent)event);
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    private void setEnabled() {
        this.enabled.set(true);
        log.debug("Dark feature '{}' enabled.", (Object)FEATURE_KEY);
    }

    private void setDisabled() {
        this.enabled.set(false);
        log.debug("Dark feature '{}' disabled.", (Object)FEATURE_KEY);
    }
}

