/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.denormalisedpermissions.impl;

import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.core.DefaultPermissionOverrideExtensionProvider;
import com.atlassian.confluence.core.PermissionOverrideExtension;
import com.atlassian.confluence.security.denormalisedpermissions.BulkPermissionService;
import com.atlassian.confluence.security.denormalisedpermissions.SimplePageContent;
import com.atlassian.confluence.security.denormalisedpermissions.impl.content.domain.SimpleContent;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.OutputTypeThreadLocal;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DenormalisedPermissionOverrideProxyServiceImpl
implements BulkPermissionService {
    private final Logger log = LoggerFactory.getLogger(DenormalisedPermissionOverrideProxyServiceImpl.class);
    private final BulkPermissionService realServiceDelegate;
    private final DefaultPermissionOverrideExtensionProvider permissionOverrideExtensionProvider;

    public DenormalisedPermissionOverrideProxyServiceImpl(BulkPermissionService realServiceDelegate, DefaultPermissionOverrideExtensionProvider permissionOverrideExtensionProvider) {
        this.realServiceDelegate = realServiceDelegate;
        this.permissionOverrideExtensionProvider = permissionOverrideExtensionProvider;
    }

    @Override
    public Map<String, Boolean> getAllSpaceKeysWithPermissionStatuses(@Nullable ConfluenceUser confluenceUser, String spacePermissionType) {
        return this.realServiceDelegate.getAllSpaceKeysWithPermissionStatuses(confluenceUser, spacePermissionType);
    }

    @Override
    public List<Space> getPermittedSpaces(SpacesQuery spaceQuery, int offset, int limit) {
        return this.realServiceDelegate.getPermittedSpaces(spaceQuery, offset, limit);
    }

    @Override
    public Set<Long> getPermittedSpaceIds(@Nullable ConfluenceUser confluenceUser, Set<Long> spaceIds, String spacePermissionType) {
        return this.realServiceDelegate.getPermittedSpaceIds(confluenceUser, spaceIds, spacePermissionType);
    }

    @Override
    public Map<Long, List<SimpleContent>> getVisibleChildPages(@Nullable ConfluenceUser confluenceUser, Set<Long> parentPageIdSet, boolean checkInheritedPermissions) {
        Map<Long, List<SimpleContent>> pages = this.realServiceDelegate.getVisibleChildPages(confluenceUser, parentPageIdSet, checkInheritedPermissions);
        return this.applyOverridesToPagesMap(confluenceUser, pages);
    }

    @Override
    public List<SimpleContent> getVisibleTopLevelPages(@Nullable ConfluenceUser confluenceUser, long spaceId) {
        List<SimpleContent> pages = this.realServiceDelegate.getVisibleTopLevelPages(confluenceUser, spaceId);
        return this.applyOverridesToPages(confluenceUser, pages);
    }

    @Override
    public List<SimpleContent> getAllVisiblePagesInSpace(@Nullable ConfluenceUser confluenceUser, long spaceId) {
        List<SimpleContent> pages = this.realServiceDelegate.getAllVisiblePagesInSpace(confluenceUser, spaceId);
        return this.applyOverridesToPages(confluenceUser, pages);
    }

    @Override
    public Set<Long> getVisiblePageIds(@Nullable ConfluenceUser confluenceUser, Set<Long> pageIds, boolean checkSpacePermissions) {
        return this.realServiceDelegate.getVisiblePageIds(confluenceUser, pageIds, checkSpacePermissions);
    }

    private List<SimpleContent> applyOverridesToPages(ConfluenceUser confluenceUser, List<SimpleContent> pages) {
        Iterable<PermissionOverrideExtension> overrides = this.permissionOverrideExtensionProvider.get();
        LinkedHashSet<SimpleContent> allowablePages = new LinkedHashSet<SimpleContent>(pages);
        boolean isExport = OutputTypeThreadLocal.get() != ConversionContextOutputType.DISPLAY;
        for (PermissionOverrideExtension extension : overrides) {
            try {
                List<SimplePageContent> filteredPages = extension.restrictBulkPageVisibility(confluenceUser, allowablePages.stream().filter(Objects::nonNull).map(SimplePageContent.class::cast).toList(), isExport);
                if (filteredPages == null) {
                    return List.of();
                }
                for (SimplePageContent page : filteredPages) {
                    allowablePages.remove(page);
                }
            }
            catch (Exception e) {
                this.log.error("Error while checking fast permissions for extension, continuing without override: {}, {}", (Object)extension.getClass().getName(), (Object)e);
            }
        }
        return allowablePages.stream().toList();
    }

    private Map<Long, List<SimpleContent>> applyOverridesToPagesMap(ConfluenceUser confluenceUser, Map<Long, List<SimpleContent>> pages) {
        HashMap<Long, List<SimpleContent>> filteredPages = new HashMap<Long, List<SimpleContent>>();
        for (Map.Entry<Long, List<SimpleContent>> entry : pages.entrySet()) {
            List<SimpleContent> filteredPage = this.applyOverridesToPages(confluenceUser, entry.getValue());
            filteredPages.put(entry.getKey(), filteredPage);
        }
        return filteredPages;
    }
}

