/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.denormalisedpermissions.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.confluence.core.persistence.schema.api.SchemaInformationService;
import com.atlassian.confluence.event.events.admin.AsyncImportFinishedEvent;
import com.atlassian.confluence.event.events.lifecycle.ApplicationStartedEvent;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.confluence.security.denormalisedpermissions.DenormalisedPermissionStateManager;
import com.atlassian.event.api.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.dialect.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterEventListeners
public class FastPermissionsEnabler {
    private static final Logger log = LoggerFactory.getLogger(FastPermissionsEnabler.class);
    private static final String DISABLE_FAST_PERMISSIONS_ENABLING_PARAMETER_NAME = "confluence.disable-fast-permissions-enabling-on-site-restore";
    private final DenormalisedPermissionStateManager denormalisedPermissionStateManager;
    private final SchemaInformationService schemaInformationService;
    private final AtomicBoolean requestToEnableServiceIsActive = new AtomicBoolean();
    private final AtomicBoolean applicationIsUpAndRunning = new AtomicBoolean();
    private final boolean disableFastPermissionsEnabling;

    public FastPermissionsEnabler(DenormalisedPermissionStateManager denormalisedPermissionStateManager, SchemaInformationService schemaInformationService) {
        this.denormalisedPermissionStateManager = denormalisedPermissionStateManager;
        this.schemaInformationService = schemaInformationService;
        this.disableFastPermissionsEnabling = Boolean.getBoolean(DISABLE_FAST_PERMISSIONS_ENABLING_PARAMETER_NAME);
    }

    @VisibleForTesting
    public FastPermissionsEnabler(DenormalisedPermissionStateManager denormalisedPermissionStateManager, SchemaInformationService schemaInformationService, boolean disableFastPermissionsEnabling) {
        this.denormalisedPermissionStateManager = denormalisedPermissionStateManager;
        this.schemaInformationService = schemaInformationService;
        this.disableFastPermissionsEnabling = disableFastPermissionsEnabling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnFastPermissionsOn() {
        FastPermissionsEnabler fastPermissionsEnabler = this;
        synchronized (fastPermissionsEnabler) {
            if (this.applicationIsUpAndRunning.get()) {
                log.info("Fast permissions will be turned on immediately.");
                this.denormalisedPermissionStateManager.enableService();
            } else {
                log.info("Confluence is still not ready. Fast permissions will be turned on when the application is up and running.");
                this.requestToEnableServiceIsActive.set(true);
            }
        }
    }

    @EventListener
    public void onImportFinishEvent(AsyncImportFinishedEvent event) {
        if (event.isSiteImport()) {
            if (this.disableFastPermissionsEnabling) {
                log.warn("Fast permissions won't be enabled on site restore because '{}' parameter was set to true", (Object)DISABLE_FAST_PERMISSIONS_ENABLING_PARAMETER_NAME);
            } else {
                log.info("Site import has been finished, fast permissions will be turned on to make Confluence more performant.");
                this.turnFastPermissionsOn();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onApplicationStartedEvent(ApplicationStartedEvent event) {
        FastPermissionsEnabler fastPermissionsEnabler = this;
        synchronized (fastPermissionsEnabler) {
            this.applicationIsUpAndRunning.set(true);
            if (this.requestToEnableServiceIsActive.get()) {
                log.info("Confluence is up an running and fast permissions are turning on now. Before, there was a request to turn fast permissions on, but the application was not ready at that moment.");
                if (this.isDatabaseSupported()) {
                    this.denormalisedPermissionStateManager.enableService();
                }
                this.requestToEnableServiceIsActive.set(false);
            }
        }
    }

    private boolean isDatabaseSupported() {
        Dialect dialect = this.schemaInformationService.getDialect();
        String dialectName = dialect.toString();
        if (HibernateConfig.isH2Dialect((String)dialectName)) {
            log.info("Fast Permissions will not be turned on by default because H2 DB can use storage that does not support locks and transactions properly. If required, Fast Permissions can be turned on manually.");
            return false;
        }
        return true;
    }
}

