/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.denormalisedpermissions.impl.content.dao;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.security.denormalisedpermissions.impl.content.domain.DenormalisedContentChangeLog;
import jakarta.persistence.criteria.CriteriaDelete;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DenormalisedContentChangeLogDao {
    private static final Logger log = LoggerFactory.getLogger(DenormalisedContentChangeLogDao.class);
    private final SessionFactory sessionFactory;

    public DenormalisedContentChangeLogDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public List<DenormalisedContentChangeLog> findContentChangeLogRecords(int limit) {
        String hqlQuery = "from DenormalisedContentChangeLog order by id";
        Query query = this.sessionFactory.getCurrentSession().createQuery(hqlQuery, DenormalisedContentChangeLog.class);
        query.setCacheable(false);
        query.setMaxResults(limit);
        return query.list();
    }

    public void removeContentChangeLogRecords(List<DenormalisedContentChangeLog> processedRecords) {
        processedRecords.forEach(arg_0 -> ((Session)this.sessionFactory.getCurrentSession()).delete(arg_0));
        log.debug("Removed {} content change log records", (Object)processedRecords.size());
    }

    public void removeAllContentChangeLogRecords() {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaDelete criteriaDelete = session.getCriteriaBuilder().createCriteriaDelete(DenormalisedContentChangeLog.class);
        criteriaDelete.from(DenormalisedContentChangeLog.class);
        session.createQuery(criteriaDelete).executeUpdate();
    }

    @VisibleForTesting
    public void saveRecord(DenormalisedContentChangeLog log) {
        this.sessionFactory.getCurrentSession().save((Object)log);
    }
}

