/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.denormalisedpermissions.impl.content.dao;

import com.atlassian.confluence.security.denormalisedpermissions.impl.content.domain.SimpleContent;
import com.atlassian.sal.api.user.UserKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealContentAndPermissionsDao {
    private static final Logger log = LoggerFactory.getLogger(RealContentAndPermissionsDao.class);
    private final SessionFactory sessionFactory;

    public RealContentAndPermissionsDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public List<SimpleContent> getSimplePageListWithIdGreaterThen(Long id, int limit) {
        Query query;
        Session session = this.sessionFactory.getCurrentSession();
        if (id != null) {
            String hqlQuery = "select new " + SimpleContent.class.getName() + "(p.id, p.space.id, p.parent.id, p.title, p.creationDate, p.lastModificationDate, p.contentStatus, p.position)  from Page p where p.originalVersion is null and p.id > :id order by id";
            query = session.createQuery(hqlQuery, SimpleContent.class);
            query.setParameter("id", (Object)id);
        } else {
            String hqlQuery = "select new " + SimpleContent.class.getName() + "(p.id, p.space.id, p.parent.id, p.title, p.creationDate, p.lastModificationDate, p.contentStatus, p.position)  from Page p where p.originalVersion is null order by id";
            query = session.createQuery(hqlQuery, SimpleContent.class);
        }
        query.setCacheable(false);
        query.setMaxResults(limit);
        return query.list();
    }

    public Map<Long, Long> getContentPermissionSets(Collection<Long> pageIdSet, String contentPermSetType) {
        if (pageIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        Session session = this.sessionFactory.getCurrentSession();
        StopWatch stopWatch = StopWatch.createStarted();
        String hqlQuery = "select new " + SimpleContentPermissionSet.class.getName() + "(s.id, s.owningContent.id)  from ContentPermissionSet s where s.type = :type and s.owningContent.id in (:contentIds)";
        Query query = session.createQuery(hqlQuery, SimpleContentPermissionSet.class);
        query.setParameter("type", (Object)contentPermSetType);
        query.setParameter("contentIds", pageIdSet);
        query.setCacheable(false);
        List plainRecords = query.list();
        Map<Long, Long> contentToPermissionSetMap = plainRecords.stream().collect(Collectors.toMap(SimpleContentPermissionSet::getContentPermSetId, SimpleContentPermissionSet::getContentId));
        log.trace("Content permissions ({}) sets for {} pages were retrieved in {} ms", new Object[]{contentToPermissionSetMap.size(), pageIdSet.size(), stopWatch.getTime()});
        return contentToPermissionSetMap;
    }

    public Map<Long, Long> getContentPermissionSetIdsForContentPermissionIds(Set<Long> contentPermSetIds) {
        if (contentPermSetIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Session session = this.sessionFactory.getCurrentSession();
        StopWatch stopWatch = StopWatch.createStarted();
        String hqlQuery = "select new " + SimpleContentPermissionSet.class.getName() + "(s.id, s.owningContent.id)  from ContentPermissionSet s where s.id in (:cpsIds)";
        Query query = session.createQuery(hqlQuery, SimpleContentPermissionSet.class);
        query.setParameter("cpsIds", contentPermSetIds);
        query.setCacheable(false);
        List plainRecords = query.list();
        Map<Long, Long> contentToPermissionSetMap = plainRecords.stream().collect(Collectors.toMap(SimpleContentPermissionSet::getContentPermSetId, SimpleContentPermissionSet::getContentId));
        log.trace("Content permissions ({}) sets were retrieved in {} ms", (Object)plainRecords, (Object)stopWatch.getTime());
        return contentToPermissionSetMap;
    }

    public List<SimpleContent> getSimpleContentList(Collection<Long> contentIds) {
        if (contentIds.isEmpty()) {
            return Collections.emptyList();
        }
        Session session = this.sessionFactory.getCurrentSession();
        String hqlQuery = "select new " + SimpleContent.class.getName() + "(p.id, p.space.id, p.parent.id, p.title, p.creationDate, p.lastModificationDate, p.contentStatus, p.position)  from Page p where p.id in (:ids)";
        Query query = session.createQuery(hqlQuery, SimpleContent.class);
        query.setParameter("ids", contentIds);
        query.setCacheable(false);
        return query.list();
    }

    public Map<Long, List<SimpleContentPermission>> getSimpleContentPermissions(Collection<Long> contentPermSetIds) {
        if (contentPermSetIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Session session = this.sessionFactory.getCurrentSession();
        StopWatch stopWatch = StopWatch.createStarted();
        String hqlQuery = "select new " + SimpleContentPermission.class.getName() + "(p.id, p.type, p.userSubject.key, p.groupName, p.owningSet.id)  from ContentPermission p where p.owningSet.id in :contentPermSetIds";
        Query query = session.createQuery(hqlQuery, SimpleContentPermission.class);
        query.setParameter("contentPermSetIds", contentPermSetIds);
        query.setCacheable(false);
        List plainRecords = query.list();
        Map<Long, List<SimpleContentPermission>> permissionSetToPermissionsMap = plainRecords.stream().collect(Collectors.groupingBy(SimpleContentPermission::getCpsId, Collectors.toList()));
        log.trace("Content permissions were retrieved in {} ms. Requested {} sets, found {} permissions for {} sets", new Object[]{stopWatch.getTime(), contentPermSetIds.size(), plainRecords.size(), permissionSetToPermissionsMap.size()});
        return permissionSetToPermissionsMap;
    }

    public static class SimpleContentPermissionSet {
        private long contentId;
        private long contentPermSetId;

        public SimpleContentPermissionSet(long contentPermSetId, long contentId) {
            this.contentPermSetId = contentPermSetId;
            this.contentId = contentId;
        }

        public long getContentId() {
            return this.contentId;
        }

        public long getContentPermSetId() {
            return this.contentPermSetId;
        }
    }

    public static class SimpleContentPermission {
        private long id;
        private String type;
        private UserKey userKey;
        private String groupName;
        private long cpsId;

        public SimpleContentPermission(long id, String type, UserKey userKey, String groupName, long cpsId) {
            this.id = id;
            this.type = type;
            this.userKey = userKey;
            this.groupName = groupName;
            this.cpsId = cpsId;
        }

        public long getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getUserName() {
            return this.userKey != null ? this.userKey.getStringValue() : null;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public long getCpsId() {
            return this.cpsId;
        }
    }
}

