/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.denormalisedpermissions.impl.manage;

import com.atlassian.confluence.event.events.lifecycle.ApplicationStartedEvent;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.confluence.security.denormalisedpermissions.impl.manage.domain.DenormalisedLock;
import com.atlassian.event.api.EventListener;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.support.TransactionTemplate;

@RegisterEventListeners
public class DenormalisedLockService {
    private static final Logger log = LoggerFactory.getLogger(DenormalisedLockService.class);
    private final SessionFactory sessionFactory;
    private final PlatformTransactionManager transactionManager;
    private final ExecutorService executor = Executors.newCachedThreadPool(ThreadFactories.namedThreadFactory((String)this.getClass().getSimpleName(), (ThreadFactories.Type)ThreadFactories.Type.DAEMON));

    public DenormalisedLockService(SessionFactory sessionFactory, PlatformTransactionManager transactionManager) {
        this.sessionFactory = sessionFactory;
        this.transactionManager = transactionManager;
    }

    public void acquireLockForTransaction(LockName lockName) {
        DenormalisedLock lockRecord = (DenormalisedLock)this.sessionFactory.getCurrentSession().get(DenormalisedLock.class, (Serializable)((Object)lockName.name()), LockMode.PESSIMISTIC_WRITE);
        if (lockRecord == null) {
            this.createRecord(lockName);
            log.info("New lock record was created on request: {}", (Object)lockName);
        }
    }

    private void createRecord(LockName lockName) {
        DenormalisedLock lock = new DenormalisedLock();
        lock.setLockName(lockName.name());
        this.sessionFactory.getCurrentSession().save((Object)lock);
    }

    public DenormalisedLock getRecord(LockName lockName) {
        return (DenormalisedLock)this.sessionFactory.getCurrentSession().get(DenormalisedLock.class, (Serializable)((Object)lockName.name()));
    }

    @EventListener
    public void onApplicationStarted(ApplicationStartedEvent applicationStartedEvent) {
        this.onApplicationStarted();
    }

    private void onApplicationStarted() {
        try {
            this.createAllLockRecordsIfTheyDoNotExist();
        }
        catch (Exception e) {
            log.error("Unable to create all lock records: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @PreDestroy
    void destroy() {
        this.executor.shutdown();
    }

    public void createAllLockRecordsIfTheyDoNotExist() throws ExecutionException, InterruptedException {
        DefaultTransactionAttribute transactionDefinition = new DefaultTransactionAttribute(3);
        Future<Void> future = this.executor.submit(() -> this.lambda$createAllLockRecordsIfTheyDoNotExist$1((TransactionDefinition)transactionDefinition));
        future.get();
    }

    private /* synthetic */ Void lambda$createAllLockRecordsIfTheyDoNotExist$1(TransactionDefinition transactionDefinition) throws Exception {
        new TransactionTemplate(this.transactionManager, transactionDefinition).execute(status -> {
            for (LockName lockName : LockName.values()) {
                if (this.getRecord(lockName) != null) continue;
                this.createRecord(lockName);
                log.debug("New lock record was created: {}", (Object)lockName);
            }
            return null;
        });
        return null;
    }

    public static enum LockName {
        SPACE_STATUS,
        SPACE_LOG_PROCESSOR,
        CONTENT_STATUS,
        CONTENT_LOG_PROCESSOR,
        UPDATE_SIDS;

    }
}

