/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.denormalisedpermissions.impl.manage;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.security.denormalisedpermissions.DenormalisedPermissionServiceState;
import com.atlassian.confluence.security.denormalisedpermissions.StateChangeInformation;
import com.atlassian.confluence.security.denormalisedpermissions.impl.manage.dao.DenormalisedChangeLogDao;
import com.atlassian.confluence.security.denormalisedpermissions.impl.manage.dao.DenormalisedServiceStateDao;
import com.atlassian.confluence.security.denormalisedpermissions.impl.manage.domain.DenormalisedServiceStateRecord;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.support.TransactionTemplate;

@Internal
public class DenormalisedPermissionStateLogService {
    private final DenormalisedServiceStateDao denormalisedServiceStateDao;
    private final PlatformTransactionManager transactionManager;
    private final DenormalisedChangeLogDao denormalisedChangeLogDao;

    public DenormalisedPermissionStateLogService(DenormalisedServiceStateDao denormalisedServiceStateDao, PlatformTransactionManager transactionManager, DenormalisedChangeLogDao denormalisedChangeLogDao) {
        this.denormalisedServiceStateDao = denormalisedServiceStateDao;
        this.transactionManager = transactionManager;
        this.denormalisedChangeLogDao = denormalisedChangeLogDao;
    }

    public DenormalisedPermissionServiceState getServiceState(DenormalisedServiceStateRecord.ServiceType serviceType) {
        DenormalisedServiceStateRecord record = this.getServiceStateRecord(serviceType);
        return record != null ? record.getState() : DenormalisedPermissionServiceState.DISABLED;
    }

    public DenormalisedServiceStateRecord getServiceStateRecord(DenormalisedServiceStateRecord.ServiceType serviceType) {
        return (DenormalisedServiceStateRecord)this.tx().execute(status -> this.denormalisedServiceStateDao.getRecord(serviceType));
    }

    public List<DenormalisedServiceStateRecord> getAllStateRecords() {
        return (List)this.tx().execute(status -> this.denormalisedServiceStateDao.getAllRecords());
    }

    public void changeState(DenormalisedServiceStateRecord stateRecord, DenormalisedPermissionServiceState newState, StateChangeInformation.MessageLevel messageLevel, String message) {
        this.addMessageToStateLog(messageLevel, message);
        stateRecord.setState(newState);
        this.denormalisedServiceStateDao.saveRecord(stateRecord);
    }

    public void changeState(DenormalisedServiceStateRecord.ServiceType serviceType, DenormalisedPermissionServiceState newState, StateChangeInformation.MessageLevel messageLevel, String message, Long lastUpToDateTimestamp) {
        DenormalisedServiceStateRecord stateRecord = this.denormalisedServiceStateDao.getRecord(serviceType);
        this.addMessageToStateLog(messageLevel, message);
        stateRecord.setState(newState);
        if (lastUpToDateTimestamp != null) {
            stateRecord.setLastUpToDateTimestamp(lastUpToDateTimestamp);
        }
    }

    public void addMessageToStateLog(StateChangeInformation.MessageLevel messageLevel, String message) {
        this.denormalisedChangeLogDao.addMessage(messageLevel, message);
    }

    public List<StateChangeInformation> getStateChangeLog(int limit) {
        return (List)this.tx().execute(status -> this.denormalisedChangeLogDao.getLastRecords(limit).stream().map(record -> new StateChangeInformation(record.getId(), record.getMessage(), this.convertToMessageLevel(record.getMessageLevel()), record.getTimestamp())).collect(Collectors.toList()));
    }

    private TransactionTemplate tx() {
        return new TransactionTemplate(this.transactionManager, (TransactionDefinition)new DefaultTransactionAttribute(0));
    }

    private StateChangeInformation.MessageLevel convertToMessageLevel(String messageLevelAsString) {
        try {
            return StateChangeInformation.MessageLevel.valueOf(messageLevelAsString);
        }
        catch (IllegalArgumentException e) {
            return StateChangeInformation.MessageLevel.ERROR;
        }
    }

    public void clearHistory() {
        this.tx().execute(status -> this.denormalisedChangeLogDao.clearHistory());
    }

    public void updateLastUpToDateTimeStamp(DenormalisedServiceStateRecord.ServiceType serviceType, long time) {
        this.denormalisedServiceStateDao.getRecord(serviceType).setLastUpToDateTimestamp(time);
    }
}

