/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.denormalisedpermissions.impl.manage.dao;

import com.atlassian.confluence.security.denormalisedpermissions.StateChangeInformation;
import com.atlassian.confluence.security.denormalisedpermissions.impl.manage.domain.DenormalisedServiceStateChangeLog;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;

public class DenormalisedChangeLogDao {
    private final SessionFactory sessionFactory;

    public DenormalisedChangeLogDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public List<DenormalisedServiceStateChangeLog> getLastRecords(int limit) {
        Session session = this.sessionFactory.getCurrentSession();
        String hqlQuery = "from DenormalisedServiceStateChangeLog order by id desc";
        Query query = session.createQuery(hqlQuery, DenormalisedServiceStateChangeLog.class);
        query.setMaxResults(limit);
        query.setCacheable(false);
        return query.list();
    }

    public Object clearHistory() {
        this.sessionFactory.getCurrentSession().createQuery("delete from DenormalisedServiceStateChangeLog").executeUpdate();
        return null;
    }

    public void addMessage(StateChangeInformation.MessageLevel level, String message) {
        DenormalisedServiceStateChangeLog log = new DenormalisedServiceStateChangeLog();
        log.setMessage(message);
        log.setMessageLevel(level.name());
        log.setTimestamp(System.currentTimeMillis());
        this.sessionFactory.getCurrentSession().save((Object)log);
    }
}

