/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.denormalisedpermissions.impl.manage.dao;

import com.atlassian.confluence.security.denormalisedpermissions.DenormalisedPermissionServiceState;
import com.atlassian.confluence.security.denormalisedpermissions.impl.manage.domain.DenormalisedServiceStateRecord;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;

public class DenormalisedServiceStateDao {
    private final SessionFactory sessionFactory;

    public DenormalisedServiceStateDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public DenormalisedServiceStateRecord getRecord(DenormalisedServiceStateRecord.ServiceType type) {
        Session session = this.sessionFactory.getCurrentSession();
        DenormalisedServiceStateRecord denormalisedServiceStateRecord = (DenormalisedServiceStateRecord)session.get(DenormalisedServiceStateRecord.class, (Serializable)((Object)type));
        if (denormalisedServiceStateRecord != null) {
            session.refresh((Object)denormalisedServiceStateRecord);
        }
        return denormalisedServiceStateRecord;
    }

    public void createRecord(DenormalisedServiceStateRecord.ServiceType serviceType, DenormalisedPermissionServiceState state) {
        Session session = this.sessionFactory.getCurrentSession();
        DenormalisedServiceStateRecord record = new DenormalisedServiceStateRecord();
        record.setState(state);
        record.setServiceType(serviceType);
        session.save((Object)record);
        session.flush();
    }

    public void saveRecord(DenormalisedServiceStateRecord stateRecord) {
        this.sessionFactory.getCurrentSession().save((Object)stateRecord);
    }

    public List<DenormalisedServiceStateRecord> getAllRecords() {
        Session session = this.sessionFactory.getCurrentSession();
        String hqlQuery = "select new " + DenormalisedServiceStateRecord.class.getName() + "(r.serviceType, r.state, r.lastUpToDateTimestamp)  from DenormalisedServiceStateRecord r";
        Query query = session.createQuery(hqlQuery, DenormalisedServiceStateRecord.class);
        query.setCacheable(false);
        return query.list();
    }
}

