/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.denormalisedpermissions.impl.space.dao;

import com.atlassian.confluence.security.denormalisedpermissions.impl.space.dao.DenormalisedSpaceChangeLogDao;
import com.atlassian.confluence.security.denormalisedpermissions.impl.space.domain.DenormalisedSpaceChangeLog;
import jakarta.persistence.criteria.CriteriaDelete;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DenormalisedSpaceChangeLogDaoImpl
implements DenormalisedSpaceChangeLogDao {
    private static final Logger log = LoggerFactory.getLogger(DenormalisedSpaceChangeLogDaoImpl.class);
    private final SessionFactory sessionFactory;

    public DenormalisedSpaceChangeLogDaoImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public List<DenormalisedSpaceChangeLog> findSpaceChangeLogRecords(int limit) {
        Session session = this.sessionFactory.getCurrentSession();
        String hqlQuery = "from DenormalisedSpaceChangeLog order by id";
        Query query = session.createQuery(hqlQuery, DenormalisedSpaceChangeLog.class);
        query.setCacheable(false);
        query.setMaxResults(limit);
        return query.list();
    }

    @Override
    public void removeSpaceChangeLogRecords(List<DenormalisedSpaceChangeLog> processedRecords) {
        Session session = this.sessionFactory.getCurrentSession();
        processedRecords.forEach(arg_0 -> ((Session)session).delete(arg_0));
        log.debug("Removed {} space change log records", (Object)processedRecords.size());
    }

    @Override
    public void saveRecord(DenormalisedSpaceChangeLog log) {
        this.sessionFactory.getCurrentSession().save((Object)log);
    }

    @Override
    public List<Long> getAllChangedSpaceIds() {
        Session session = this.sessionFactory.getCurrentSession();
        String hqlQuery = "select distinct log.spaceId from DenormalisedSpaceChangeLog log";
        Query query = session.createQuery(hqlQuery, Long.class);
        query.setCacheable(false);
        return query.list();
    }

    @Override
    public void removeAllSpaceChangeLogRecords() {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaDelete criteriaDelete = session.getCriteriaBuilder().createCriteriaDelete(DenormalisedSpaceChangeLog.class);
        criteriaDelete.from(DenormalisedSpaceChangeLog.class);
        session.createQuery(criteriaDelete).executeUpdate();
    }
}

