/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.denormalisedpermissions.impl.space.dao;

import com.atlassian.confluence.security.denormalisedpermissions.impl.space.dao.SpaceKeyWithPermission;
import com.atlassian.confluence.security.denormalisedpermissions.impl.space.domain.DenormalisedSpacePermission;
import com.atlassian.confluence.security.denormalisedpermissions.impl.space.domain.SpacePermissionType;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.spaces.SpacesQuery;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;

@SuppressFBWarnings(value={"SQL_INJECTION_HIBERNATE"}, justification="Enum values are used for building SQL queries, so SQL injections are not possible. Can't apply the annotation to the particular method due to this bug: https://github.com/spotbugs/spotbugs/issues/724")
public class DenormalisedSpacePermissionDao {
    public static final long ANONYMOUS_USERS_SID = -1L;
    public static final long ALL_AUTHENTICATED_USERS_SID = -2L;
    public static final long FULL_CONFLUENCE_ACCESS = -3L;
    private final SessionFactory sessionFactory;

    public DenormalisedSpacePermissionDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Map<Long, List<DenormalisedSpacePermission>> findPermissionsForSpaces(Set<Long> spaceIds, SpacePermissionType permissionType) {
        if (spaceIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Session session = this.sessionFactory.getCurrentSession();
        String hqlQuery = "from " + permissionType.getEntityName() + " where spaceToSidMapId.spaceId in (:spaceIdList)";
        Query query = session.createQuery(hqlQuery, DenormalisedSpacePermission.class);
        query.setParameter("spaceIdList", spaceIds);
        query.setCacheable(false);
        return query.list().stream().collect(Collectors.groupingBy(permission -> permission.getSpaceToSidMapId().getSpaceId()));
    }

    public List<Space> findPermittedSpaces(List<Long> sidList, SpacePermissionType permissionType) {
        if (sidList.isEmpty()) {
            return Collections.emptyList();
        }
        Session session = this.sessionFactory.getCurrentSession();
        String hqlQuery = "select s from Space s where s.id in (select p.spaceToSidMapId.spaceId from " + permissionType.getEntityName() + " p where spaceToSidMapId.sidId in (:sidIdList))";
        Query query = session.createQuery(hqlQuery, Space.class);
        query.setParameter("sidIdList", sidList);
        query.setCacheable(true);
        return query.list();
    }

    public Set<Long> findPermittedSpaceIds(Set<Long> sids, Set<Long> spaceIds, SpacePermissionType permissionType) {
        if (sids.isEmpty() || spaceIds.isEmpty()) {
            return Collections.emptySet();
        }
        Session session = this.sessionFactory.getCurrentSession();
        String hqlQuery = "select distinct p.spaceToSidMapId.spaceId from " + permissionType.getEntityName() + " p where spaceToSidMapId.sidId in (:sids) and spaceToSidMapId.spaceId in (:spaceIds)";
        Query query = session.createQuery(hqlQuery, Long.class);
        query.setParameter("sids", sids);
        query.setParameter("spaceIds", spaceIds);
        query.setCacheable(false);
        return new HashSet<Long>(query.list());
    }

    public List<SpaceKeyWithPermission> getAllSpacesKeysWithPermissionInfo(Set<Long> sids, SpacePermissionType permissionType) {
        Session session = this.sessionFactory.getCurrentSession();
        if (!sids.isEmpty()) {
            String permittedSpaceIdHqlQuery = "select distinct s.id from Space s INNER JOIN " + permissionType.getEntityName() + " d ON s.id = d.spaceToSidMapId.spaceId AND d.spaceToSidMapId.sidId in (:sids)";
            List permittedSpaceIdList = session.createQuery(permittedSpaceIdHqlQuery, Long.class).setParameter("sids", sids).setCacheable(true).list();
            List spaceIdToKeyQueryResult = session.createNamedQuery("confluence.space_getAllSpaceIdsAndKeys", Object[].class).setCacheable(true).setCacheRegion("com.atlassian.confluence.spaces.Space").list();
            HashSet permittedSpaceIdSet = new HashSet(permittedSpaceIdList);
            return spaceIdToKeyQueryResult.stream().map(row -> new SpaceKeyWithPermission((String)row[1], permittedSpaceIdSet.contains((Long)row[0]))).collect(Collectors.toList());
        }
        String hqlQuery = "select distinct new " + SpaceKeyWithPermission.class.getName() + "(s.key, false) from Space s";
        Query query = session.createQuery(hqlQuery, SpaceKeyWithPermission.class);
        query.setCacheable(true);
        return query.list();
    }

    public void removeRecord(DenormalisedSpacePermission spacePermission, SpacePermissionType spacePermissionType) {
        this.sessionFactory.getCurrentSession().delete(spacePermissionType.getEntityName(), (Object)spacePermission);
    }

    public void addRecord(DenormalisedSpacePermission spacePermission, SpacePermissionType spacePermissionType) {
        this.sessionFactory.getCurrentSession().save(spacePermissionType.getEntityName(), (Object)spacePermission);
    }

    public List<Space> getSpaces(Set<Long> sids, SpacePermissionType permissionType, SpacesQuery spaceQuery, int offset, int limit, boolean permissionExempt) {
        List<String> sortBy;
        Set<SpaceStatus> spaceStatuses;
        Set<Long> spaceIdSet;
        if (sids.isEmpty()) {
            return Collections.emptyList();
        }
        Session session = this.sessionFactory.getCurrentSession();
        StringBuilder hqlQuery = new StringBuilder("select s from Space s");
        if (!permissionExempt) {
            hqlQuery.append(" where s.id in (select p.spaceToSidMapId.spaceId from " + permissionType.getEntityName() + " p where spaceToSidMapId.sidId in (:sids))");
        } else {
            hqlQuery.append(" where 1 = 1");
        }
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        List<String> spaceKeys = spaceQuery.getSpaceKeys();
        if (spaceKeys != null && !spaceKeys.isEmpty()) {
            hqlQuery.append(" and s.lowerKey in (:spaceKeyList)");
            queryParameters.put("spaceKeyList", spaceKeys.stream().map(String::toLowerCase).collect(Collectors.toList()));
        }
        if ((spaceIdSet = spaceQuery.getSpaceIds()) != null && !spaceIdSet.isEmpty()) {
            hqlQuery.append(" and s.id in (:spaceIdSet)");
            queryParameters.put("spaceIdSet", spaceIdSet);
        }
        if ((spaceStatuses = spaceQuery.getSpaceStatuses()) != null && !spaceStatuses.isEmpty()) {
            hqlQuery.append(" and s.spaceStatus in (:spaceStatusList)");
            queryParameters.put("spaceStatusList", spaceStatuses);
        }
        if ((sortBy = spaceQuery.getSortBy()) != null && !sortBy.isEmpty()) {
            hqlQuery.append(" order by ");
            hqlQuery.append(String.join((CharSequence)",", sortBy));
        }
        Query query = session.createQuery(hqlQuery.toString(), Space.class);
        if (!permissionExempt) {
            query.setParameter("sids", sids);
        }
        queryParameters.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        boolean enableCaching = limit < 100;
        query.setCacheable(enableCaching);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.list();
    }

    public List<Long> getOrphanSpacesInFastPermissions(SpacePermissionType spacePermissionType, int limit) {
        Session session = this.sessionFactory.getCurrentSession();
        String hqlQuery = "select distinct sp.spaceToSidMapId.spaceId from " + spacePermissionType.getEntityName() + " sp left join Space s on s.id = sp.spaceToSidMapId.spaceId where s.id is null";
        Query query = session.createQuery(hqlQuery, Long.class);
        query.setMaxResults(limit);
        return query.list();
    }

    public void deleteFastSpacePermissionsForSpaces(SpacePermissionType spacePermissionType, Collection<Long> spaceIds) {
        Session session = this.sessionFactory.getCurrentSession();
        String hqlQuery = "delete from " + spacePermissionType.getEntityName() + " sp where sp.spaceToSidMapId.spaceId in (:spaceIds)";
        Query query = session.createQuery(hqlQuery);
        query.setParameter("spaceIds", spaceIds);
        query.executeUpdate();
    }
}

