/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.interceptors;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.setup.struts.AbstractAwareInterceptor;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.spring.container.ContainerManager;
import java.util.function.Supplier;
import org.apache.struts2.ActionInvocation;

public class CaptchaInterceptor
extends AbstractAwareInterceptor {
    private final Supplier<CaptchaManager> captchaManagerSupplier = MemoizingComponentReference.containerComponent("captchaManager");

    @Override
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        Object action = actionInvocation.getAction();
        if (action instanceof CaptchaAware) {
            CaptchaAware captchaAwareAction = (CaptchaAware)action;
            if (action instanceof ConfluenceActionSupport) {
                CaptchaManager captchaManager;
                ConfluenceActionSupport cas = (ConfluenceActionSupport)action;
                if (ContainerManager.isContainerSetup() && ((captchaManager = this.captchaManagerSupplier.get()).isCaptchaEnabled() || captchaAwareAction.mustValidateCaptcha())) {
                    boolean isCaptchaValidated;
                    String captchaId = this.getParameter("captchaId");
                    String captchaResponse = this.getParameter("captchaResponse");
                    boolean bl = isCaptchaValidated = captchaAwareAction.mustValidateCaptcha() ? captchaManager.forceValidateCaptcha(captchaId, captchaResponse) : captchaManager.validateCaptcha(captchaId, captchaResponse);
                    if (!isCaptchaValidated) {
                        cas.addFieldError("captcha", "captcha.response.failed", new String[0]);
                        return "input";
                    }
                }
            }
        }
        return actionInvocation.invoke();
    }
}

