/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.persistence.dao.hibernate;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.core.persistence.hibernate.HibernateObjectDao;
import com.atlassian.confluence.core.persistence.schema.api.SchemaInformationService;
import com.atlassian.confluence.impl.hibernate.query.InExpressionBuilder;
import com.atlassian.confluence.impl.security.NeverPermittedContentPermissionSet;
import com.atlassian.confluence.internal.security.persistence.ContentPermissionSetDaoInternal;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateContentPermissionSetDao
extends HibernateObjectDao<ContentPermissionSet>
implements ContentPermissionSetDaoInternal {
    private static final int MAX_IN_CLAUSE_SIZE = Integer.getInteger("confluence.hibernate.content.permission.set.max.in.clause", 2000);
    private static final Logger log = LoggerFactory.getLogger(HibernateContentPermissionSetDao.class);
    private SchemaInformationService schemaInformationService;

    public SchemaInformationService getSchemaInformationService() {
        return this.schemaInformationService;
    }

    public void setSchemaInformationService(SchemaInformationService schemaInformationService) {
        this.schemaInformationService = schemaInformationService;
    }

    @Override
    public ContentPermissionSet getById(long id) {
        return (ContentPermissionSet)this.getByClassId(id);
    }

    @Override
    public Map<Long, List<ContentPermissionSet>> getExplicitPermissionSetsFor(Collection<Long> ids) {
        HashMap result = Maps.newHashMap();
        HashSet contentPermissionSets = new HashSet();
        for (List innerIds : Lists.partition(new ArrayList<Long>(ids), (int)MAX_IN_CLAUSE_SIZE)) {
            List innerContentPermissionSets = Objects.requireNonNull(this.hibernate().execute(session -> {
                InExpressionBuilder inExpressionBuilder = InExpressionBuilder.getInExpressionBuilderDefaultLimit((String)"content.id", (String)"ids", (Dialect)this.schemaInformationService.getDialect());
                String queryString = "select distinct cps from ContentEntityObject as content join content.contentPermissionSets as cps join fetch cps.contentPermissions as cp where " + inExpressionBuilder.convertIdsToInClauseString(innerIds) + " order by content.id";
                return session.createQuery(queryString, ContentPermissionSet.class).setHint("hibernate.query.passDistinctThrough", (Object)false).list();
            }));
            contentPermissionSets.addAll(innerContentPermissionSets);
        }
        Map<Long, List<ContentPermissionSet>> tempResult = contentPermissionSets.stream().collect(Collectors.groupingBy(permissionSet -> permissionSet.getOwningContent().getId()));
        Iterator<Long> iterator = ids.iterator();
        while (iterator.hasNext()) {
            Long id;
            ArrayList permissionSet2 = tempResult.get(id = iterator.next());
            result.put(id, permissionSet2 == null ? new ArrayList() : permissionSet2);
        }
        return result;
    }

    @Override
    public List<ContentPermissionSet> getInheritedContentPermissionSets(Page page, String type) {
        return this.hibernate().execute(session -> {
            Query ancestorQuery = session.createQuery("select pageAncestors.id from Page as page left join page.ancestors as pageAncestors where page.id = :pageId");
            ancestorQuery.setParameter("pageId", (Object)page.getId());
            HashSet ancestors = new HashSet(ancestorQuery.list());
            if (page.getParent() != null && !ancestors.contains(page.getParent().getId())) {
                this.logAncestorsTableFailure(page);
                return Collections.singletonList(NeverPermittedContentPermissionSet.buildFrom(type, page));
            }
            if (type != null && !ancestors.isEmpty()) {
                Query cpsQuery = session.createQuery("select cps from ContentPermissionSet as cps where cps.type = :cpsType and cps.owningContent.id in (:ancestorIds)");
                cpsQuery.setParameterList("ancestorIds", ancestors);
                cpsQuery.setParameter("cpsType", (Object)type);
                return cpsQuery.list();
            }
            return Collections.emptyList();
        });
    }

    @Override
    public Map<Long, List<ContentPermissionSet>> getInheritedContentPermissionSets(Collection<Long> pageIds) {
        return this.hibernate().execute(session -> {
            if (pageIds.isEmpty()) {
                return Collections.emptyMap();
            }
            SetMultimap<Long, Long> ancestorsByPageId = HibernateContentPermissionSetDao.getAncestors(session, pageIds);
            if (ancestorsByPageId.isEmpty()) {
                return Collections.emptyMap();
            }
            HashSet<Long> ancestors = new HashSet<Long>(ancestorsByPageId.values());
            Collection<ContentPermissionSet> contentPermissionSets = HibernateContentPermissionSetDao.getContentPermissionSets(session, this.schemaInformationService.getDialect(), ancestors);
            return (Map)pageIds.stream().collect(ImmutableMap.toImmutableMap(pageId -> pageId, pageId -> {
                Set ancestorIds = ancestorsByPageId.get(pageId);
                Predicate<ContentPermissionSet> filter = cps -> ancestorIds.contains(cps.getOwningContent().getId());
                return (List)contentPermissionSets.stream().filter(filter).collect(ImmutableList.toImmutableList());
            }));
        });
    }

    @Override
    public Map<ContentId, PageResponse<ContentPermissionSet>> getRelevantViewRestrictionsForContent(LimitedRequest pageRequest, Map<Long, Long> contentIdToParentIdMap) {
        return (Map)this.hibernate().execute(session -> {
            SetMultimap<Long, Long> ancestorsByPageId = HibernateContentPermissionSetDao.getAncestors(session, contentIdToParentIdMap.keySet());
            for (Map.Entry entry : contentIdToParentIdMap.entrySet()) {
                ArrayList allAncestorFromDB = new ArrayList(ancestorsByPageId.get((Object)((Long)entry.getKey())));
                if ((Long)entry.getValue() <= 0L || allAncestorFromDB.contains(entry.getValue())) continue;
                log.warn("Invalid permission model detected for content {} as its parent does not belong to ancestor list", entry.getKey());
                contentIdToParentIdMap.remove(entry.getKey());
            }
            SetMultimap<Long, Long> relevantViewRestrictionAncestorsByPageId = HibernateContentPermissionSetDao.getAncestorsWithViewPermissionSet(session, contentIdToParentIdMap.keySet());
            Collection<Long> contentWithViewPermission = HibernateContentPermissionSetDao.getContentWithViewPermissionSet(session, contentIdToParentIdMap.keySet());
            relevantViewRestrictionAncestorsByPageId.keySet().forEach(contentId -> {
                if (contentWithViewPermission.contains(contentId)) {
                    relevantViewRestrictionAncestorsByPageId.get(contentId).add(contentId);
                }
            });
            ArrayList<Long> paginatingRelevantViewRestrictionAncestorsByPageId = new ArrayList<Long>();
            HashMap mapContentIdToCurrentQueryPage = new HashMap();
            for (Long queryContentId : relevantViewRestrictionAncestorsByPageId.keySet()) {
                ArrayList relevantViewRestrictionAncestors = new ArrayList(relevantViewRestrictionAncestorsByPageId.get((Object)queryContentId));
                Collections.sort(relevantViewRestrictionAncestors);
                if (pageRequest.getStart() > relevantViewRestrictionAncestors.size()) continue;
                int startIndex = Math.max(pageRequest.getStart(), 0);
                List sublist = relevantViewRestrictionAncestors.subList(startIndex, Math.min(pageRequest.getLimit() + startIndex + 1, relevantViewRestrictionAncestors.size()));
                paginatingRelevantViewRestrictionAncestorsByPageId.addAll(sublist);
                mapContentIdToCurrentQueryPage.put(queryContentId, sublist);
            }
            contentIdToParentIdMap.keySet().stream().filter(id -> !relevantViewRestrictionAncestorsByPageId.keySet().contains(id)).forEach(orphanId -> {
                mapContentIdToCurrentQueryPage.put((Long)orphanId, List.of(orphanId));
                paginatingRelevantViewRestrictionAncestorsByPageId.add((Long)orphanId);
            });
            List<ContentPermissionSet> contentPermissionSets = HibernateContentPermissionSetDao.getContentPermissionSets(session, paginatingRelevantViewRestrictionAncestorsByPageId, List.of("View"));
            return (ImmutableMap)contentIdToParentIdMap.keySet().stream().map(ContentId::of).collect(ImmutableMap.toImmutableMap(contentId -> contentId, contentId -> {
                List mapSublist = (List)mapContentIdToCurrentQueryPage.get(contentId.asLong());
                Predicate<ContentPermissionSet> filter = cps -> {
                    List newMapSublist = mapSublist;
                    if (mapSublist.size() > pageRequest.getLimit()) {
                        newMapSublist = mapSublist.subList(0, pageRequest.getLimit());
                    }
                    return newMapSublist.contains(cps.getOwningContent().getId());
                };
                List paginatedPMSList = (List)contentPermissionSets.stream().filter(filter).collect(ImmutableList.toImmutableList());
                return PageResponseImpl.from((Iterable)paginatedPMSList, (mapSublist != null && mapSublist.size() > pageRequest.getLimit() ? 1 : 0) != 0).build();
            }));
        });
    }

    private static List<ContentPermissionSet> getContentPermissionSets(Session session, Collection<Long> pageIds, Collection<String> cpsTypes) {
        return session.createQuery("select distinct cps from ContentPermissionSet as cps left join fetch cps.contentPermissions join cps.owningContent where cps.owningContent.id in (:pageIds) and cps.type in (:types)", ContentPermissionSet.class).setParameterList("pageIds", pageIds).setParameterList("types", cpsTypes).setHint("hibernate.query.passDistinctThrough", (Object)false).list();
    }

    private static Collection<ContentPermissionSet> getContentPermissionSets(Session session, Dialect dialect, Collection<Long> pageIds) {
        LinkedHashSet<ContentPermissionSet> result = new LinkedHashSet<ContentPermissionSet>();
        for (List innerIds : Lists.partition(new ArrayList<Long>(pageIds), (int)MAX_IN_CLAUSE_SIZE)) {
            InExpressionBuilder inExpressionBuilder = InExpressionBuilder.getInExpressionBuilderDefaultLimit((String)"cps.owningContent.id", (String)"pageIds", (Dialect)dialect);
            String queryString = "select distinct cps from ContentPermissionSet as cps left join fetch cps.contentPermissions join cps.owningContent where " + inExpressionBuilder.convertIdsToInClauseString(innerIds);
            result.addAll(session.createQuery(queryString, ContentPermissionSet.class).setHint("hibernate.query.passDistinctThrough", (Object)false).list());
        }
        return result;
    }

    private static SetMultimap<Long, Long> getAncestorsWithViewPermissionSet(Session session, Collection<Long> pageIds) {
        Query ancestorQuery = session.createQuery("select page.id, pageAncestors.id from Page as page join page.ancestors as pageAncestors join ContentPermissionSet cps on cps.owningContent.id = pageAncestors.id where page.id in (:pageIds) and cps.type = :type order by page.id, pageAncestors.id", Object[].class);
        ancestorQuery.setParameter("pageIds", pageIds);
        ancestorQuery.setParameter("type", (Object)"View");
        return (SetMultimap)ancestorQuery.list().stream().collect(Multimaps.toMultimap(row -> Objects.requireNonNull((Long)row[0]), row -> Objects.requireNonNull((Long)row[1]), HashMultimap::create));
    }

    private static Collection<Long> getContentWithViewPermissionSet(Session session, Collection<Long> pageIds) {
        Query ancestorQuery = session.createQuery("select distinct page.id from Page as page join ContentPermissionSet cps on cps.owningContent.id = page.id where page.id in (:pageIds) and cps.type = :type order by page.id", Long.class);
        ancestorQuery.setParameter("pageIds", pageIds);
        ancestorQuery.setParameter("type", (Object)"View");
        return ancestorQuery.list();
    }

    private static SetMultimap<Long, Long> getAncestors(Session session, Collection<Long> pageIds) {
        Query ancestorQuery = session.createQuery("select page.id, pageAncestors.id from Page as page join page.ancestors as pageAncestors where page.id in (:pageIds)", Object[].class);
        ancestorQuery.setParameter("pageIds", pageIds);
        return (SetMultimap)ancestorQuery.list().stream().collect(Multimaps.toMultimap(row -> Objects.requireNonNull((Long)row[0]), row -> Objects.requireNonNull((Long)row[1]), HashMultimap::create));
    }

    @Override
    public Map<Long, Set<ContentPermissionSet>> getPermissionSets(String spaceKey, List<Long> contentIds) {
        String hql = "select cps from ContentPermissionSet cps join cps.owningContent as content where content.space.key = :spaceKey and content.originalVersion is null and content.id in (:contentIds)";
        List permissionSets = this.getSessionFactory().getCurrentSession().createQuery(hql, ContentPermissionSet.class).setParameter("spaceKey", (Object)spaceKey).setParameterList("contentIds", contentIds).list();
        return this.groupPermissionByContentId(permissionSets);
    }

    @Override
    public List<Long> getContentIdsWithPermissionSet(String spaceKey) {
        return this.hibernate().execute(session -> {
            Query query = session.createQuery("select page.id from Page as page join page.contentPermissionSets as cps where page.originalVersion is null and page.space.key = :spaceKey");
            query.setParameter("spaceKey", (Object)spaceKey);
            return query.list();
        });
    }

    @Override
    public void remove(ContentPermissionSet contentPermissionSet) {
        super.remove(contentPermissionSet);
    }

    private Map<Long, Set<ContentPermissionSet>> groupPermissionByContentId(List<ContentPermissionSet> permissionSets) {
        return permissionSets.stream().collect(Collectors.groupingBy(permission -> permission.getOwningContent().getContentId().asLong(), Collectors.toSet()));
    }

    private void logAncestorsTableFailure(Page page) {
        String message = "Detected ancestors table corruption for pageId: {}. Access to this page is blocked for all users as inherited permissions cannot be determined. To resolve this, rebuild the ancestors table. See https://confluence.atlassian.com/display/DOC/Rebuilding+the+Ancestor+Table";
        log.error("Detected ancestors table corruption for pageId: {}. Access to this page is blocked for all users as inherited permissions cannot be determined. To resolve this, rebuild the ancestors table. See https://confluence.atlassian.com/display/DOC/Rebuilding+the+Ancestor+Table", (Object)page.getId());
    }

    @Override
    public Class<ContentPermissionSet> getPersistentClass() {
        return ContentPermissionSet.class;
    }
}

