/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.persistence.dao.hibernate;

import com.atlassian.confluence.core.persistence.hibernate.ConfluenceHibernateObjectDao;
import com.atlassian.confluence.core.persistence.hibernate.HibernateObjectDao;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.persistence.dao.SpacePermissionDao;
import com.atlassian.confluence.security.persistence.dao.hibernate.SpacePermissionDTOLight;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class HibernateSpacePermissionDao
extends ConfluenceHibernateObjectDao<SpacePermission>
implements SpacePermissionDao {
    @Override
    public Class<SpacePermission> getPersistentClass() {
        return SpacePermission.class;
    }

    @Override
    public SpacePermission getById(long id) {
        return (SpacePermission)this.getByClassId(id);
    }

    @Override
    public boolean hasPermission(SpacePermission permission) {
        QueryParamRecord paramRecord = this.buildSpacePermissionQueryBySubject(permission);
        List<SpacePermission> result = this.executeSpacePermissionQueryBySubject(permission, paramRecord);
        return !result.isEmpty();
    }

    @Override
    public List<SpacePermission> findAllGlobalPermissions() {
        return this.findNamedQuery("confluence.sp_findAllGlobalPermissions");
    }

    @Override
    public List<SpacePermission> findAllGlobalPermissionsForType(String permissionType) {
        return this.findNamedQueryStringParam("confluence.sp_findAllGlobalPermissionsForType", "type", permissionType);
    }

    @Override
    public List<SpacePermission> findPermissionsForGroup(String group) {
        return this.findNamedQueryStringParam("confluence.sp_findPermissionsForGroup", "group", group);
    }

    @Override
    public List<SpacePermission> findPermissionsForSpace(Space space) {
        return this.findNamedQueryStringParam("confluence.sp_findPermissionsForSpace", "spaceid", space.getId());
    }

    @Override
    public List<SpacePermissionDTOLight> findPermissionsForSpacesAndTypes(Set<Long> spaceIdList, Collection<String> typeList) {
        return this.getSessionFactory().getCurrentSession().createQuery("select new com.atlassian.confluence.security.persistence.dao.hibernate.SpacePermissionDTOLight(sp.id, sp.userSubject.key, sp.group, sp.type, sp.allUsersSubject, sp.space.id) from SpacePermission sp where space.id in (:spaceIdList) and sp.type in (:typeList)", SpacePermissionDTOLight.class).setParameter("spaceIdList", spaceIdList).setParameter("typeList", typeList).list();
    }

    @Override
    public Collection<SpacePermission> findGroupPermissionsForSpace(Space space, String permissionType) {
        return this.findNamedQueryStringParams("confluence.sp_findPermittedGroupPermissionsForSpace", "spaceid", space.getId(), "type", (Object)permissionType, HibernateObjectDao.Cacheability.NOT_CACHEABLE);
    }

    @Override
    public Collection<SpacePermission> findGlobalGroupPermissions(String permissionType) {
        return this.findNamedQueryStringParam("confluence.sp_findGlobalPermittedGroupPermissions", "type", permissionType, HibernateObjectDao.Cacheability.NOT_CACHEABLE);
    }

    @Override
    public void remove(SpacePermission spacePermission) {
        super.remove(spacePermission);
    }

    @Override
    public List<SpacePermission> findPermissionsForUser(ConfluenceUser user) {
        return this.findNamedQueryStringParam("confluence.sp_findPermissionsForUser", "user", user);
    }

    @Override
    public List<SpacePermission> findPermissionsForUserInSpace(ConfluenceUser user, Space space) {
        return this.findNamedQueryStringParams("confluence.sp_findPermissionsForUserInSpace", "user", user, "spaceid", (Object)space.getId());
    }

    @Override
    public List<SpacePermission> findPermissionsForGroupInSpace(String group, Space space) {
        return this.findNamedQueryStringParams("confluence.sp_findPermissionsForGroupInSpace", "group", group, "spaceid", (Object)space.getId());
    }

    @Override
    public List<SpacePermission> findPermissionsForAnonymousUsers(Space space) {
        return this.findNamedQueryStringParam("confluence.sp_findPermissionsForAnonymousUsersInSpace", "spaceid", space.getId());
    }

    public void removePermissionsForUser(ConfluenceUser user) {
        this.delete("from SpacePermission where userSubject = :user", query -> query.setParameter("user", (Object)user));
    }

    public void removePermissionsForGroup(String group) {
        this.delete("from SpacePermission where group = :group", query -> query.setParameter("group", (Object)group));
    }

    @Override
    public void removePermissionsForSpace(Space space) {
        this.delete("from SpacePermission where space.id = :spaceId", query -> query.setParameter("spaceId", (Object)space.getId()));
    }

    private void delete(String hql, Consumer<Query<SpacePermission>> q) {
        Session session = this.getSessionFactory().getCurrentSession();
        Query query = session.createQuery(hql, SpacePermission.class);
        q.accept((Query<SpacePermission>)query);
        query.stream().forEach(arg_0 -> ((Session)session).delete(arg_0));
    }

    @Override
    public List findPermissionTypes(SpacePermission permission) {
        QueryParamRecord paramRecord = this.buildSpacePermissionQueryBySubjectIgnoringTypeField(permission);
        return this.executeSpacePermissionQueryBySubject(permission, paramRecord);
    }

    private List<SpacePermission> executeSpacePermissionQueryBySubject(SpacePermission permission, QueryParamRecord paramRecord) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(paramRecord.hql.toString(), SpacePermission.class);
        query.setCacheable(false);
        if (paramRecord.hasSpace) {
            query.setParameter("spaceId", (Object)permission.getSpaceId());
        }
        if (paramRecord.hasGroup) {
            query.setParameter("group", (Object)permission.getGroup());
        }
        if (paramRecord.hasUserSubject) {
            query.setParameter("userSubject", (Object)permission.getUserSubject());
        }
        if (paramRecord.hasAllUsersSubject) {
            query.setParameter("allUsersSubject", (Object)permission.getAllUsersSubject());
        }
        if (paramRecord.hasType) {
            query.setParameter("type", (Object)permission.getType());
        }
        return query.list();
    }

    private QueryParamRecord buildSpacePermissionQueryBySubjectIgnoringTypeField(SpacePermission permission) {
        QueryParamRecord paramRecord = new QueryParamRecord();
        paramRecord.hql.append("from SpacePermission sp ");
        if (permission.getSpace() == null) {
            paramRecord.hql.append("where sp.space is null ");
        } else {
            paramRecord.hql.append("where sp.space.id = :spaceId ");
            paramRecord.hasSpace = true;
        }
        if (permission.getGroup() == null) {
            paramRecord.hql.append("and sp.group is null ");
        } else {
            paramRecord.hql.append("and sp.group = :group ");
            paramRecord.hasGroup = true;
        }
        if (permission.getUserSubject() == null) {
            paramRecord.hql.append("and sp.userSubject is null ");
        } else {
            paramRecord.hql.append("and sp.userSubject = :userSubject ");
            paramRecord.hasUserSubject = true;
        }
        if (permission.getAllUsersSubject() == null) {
            paramRecord.hql.append("and sp.allUsersSubject is null ");
        } else {
            paramRecord.hql.append("and sp.allUsersSubject = :allUsersSubject ");
            paramRecord.hasAllUsersSubject = true;
        }
        return paramRecord;
    }

    private QueryParamRecord buildSpacePermissionQueryBySubject(SpacePermission permission) {
        QueryParamRecord paramRecord = this.buildSpacePermissionQueryBySubjectIgnoringTypeField(permission);
        if (permission.getType() == null) {
            paramRecord.hql.append("and sp.type is null");
        } else {
            paramRecord.hql.append("and sp.type = :type");
            paramRecord.hasType = true;
        }
        return paramRecord;
    }

    private static class QueryParamRecord {
        boolean hasSpace;
        boolean hasGroup;
        boolean hasUserSubject;
        boolean hasAllUsersSubject;
        boolean hasType;
        StringBuilder hql = new StringBuilder();

        private QueryParamRecord() {
        }
    }
}

