/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.persistence.dao.hibernate;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import org.apache.commons.codec.binary.Base64;

public class KeyTransferBean
implements Serializable {
    public static final String TYPE_PRIVATE = "private";
    public static final String TYPE_PUBLIC = "public";
    private String keyType;
    private String algorithm;
    private String encodedKey;

    public KeyTransferBean(String asCData) {
        String[] split = asCData.split("\\s+");
        if (split.length != 5) {
            throw new IllegalArgumentException("Input provided : " + asCData + " is not a valid KeyTransferBean");
        }
        this.algorithm = split[1];
        this.keyType = split[2];
        this.encodedKey = split[3];
    }

    public KeyTransferBean(String type, String algorithm, String encodedKey) {
        this.keyType = type;
        this.algorithm = algorithm;
        this.encodedKey = encodedKey;
    }

    public KeyTransferBean(Key key) {
        this.keyType = key instanceof PrivateKey ? TYPE_PRIVATE : TYPE_PUBLIC;
        this.algorithm = key.getAlgorithm();
        this.encodedKey = this.encodeKey(key);
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getEncodedKey() {
        return this.encodedKey;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setEncodedKey(String encodedKey) {
        this.encodedKey = encodedKey;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String encodeKey(Key key) {
        return new String(Base64.encodeBase64((byte[])key.getEncoded()), StandardCharsets.US_ASCII);
    }

    public String asCDataEncodedString() {
        return KeyTransferBean.CDatafyString(this.algorithm + " " + this.keyType + " " + this.encodedKey);
    }

    public static String CDatafyString(String s) {
        return "<![CDATA[ " + s + " ]]>";
    }
}

