/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.persistence.dao.hibernate;

import com.atlassian.confluence.security.login.HistoricalLoginInfo;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.google.common.base.Preconditions;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Target;

@Entity
@Table(name="logininfo")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@NamedQuery(name="confluence.la_getAuditInfoByUsername", query="from UserLoginInfo as li WHERE li.user = :user order by li.id desc")
@Proxy(lazy=false)
public class UserLoginInfo
implements Serializable,
HistoricalLoginInfo {
    @Id
    @Column(name="id", updatable=false)
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    @GeneratedValue(generator="resettable-hilo-v5")
    private long id;
    @Column(name="CURFAILED")
    private int currentFailedLoginCount;
    @Column(name="TOTALFAILED")
    private int totalFailedLoginCount;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="SUCCESSDATE")
    private Date lastSuccessfulLoginDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="PREVSUCCESSDATE")
    private Date previousSuccessfulLoginDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="FAILEDDATE")
    private Date lastFailedLoginDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="USERNAME", nullable=false, unique=true, foreignKey=@ForeignKey(name="FK_logininfo_USERNAME"))
    @Target(value=ConfluenceUserImpl.class)
    private ConfluenceUser user;

    public UserLoginInfo() {
    }

    public UserLoginInfo(ConfluenceUser user) {
        this.user = (ConfluenceUser)Preconditions.checkNotNull((Object)user);
    }

    public void successfulLogin(Date date, boolean resetFailedLoginCount) {
        this.previousSuccessfulLoginDate = this.lastSuccessfulLoginDate;
        this.lastSuccessfulLoginDate = date;
        if (resetFailedLoginCount) {
            this.resetFailedLoginCount();
        }
    }

    public void successfulLogin(Date date) {
        this.successfulLogin(date, true);
    }

    public void failedLogin(Date date) {
        ++this.totalFailedLoginCount;
        ++this.currentFailedLoginCount;
        this.lastFailedLoginDate = date;
    }

    public void resetFailedLoginCount() {
        this.currentFailedLoginCount = 0;
    }

    @Override
    public Date getPreviousSuccessfulLoginDate() {
        return this.previousSuccessfulLoginDate;
    }

    public long getId() {
        return this.id;
    }

    public ConfluenceUser getUser() {
        return this.user;
    }

    @Override
    public int getCurrentFailedLoginCount() {
        return this.currentFailedLoginCount;
    }

    @Override
    public int getTotalFailedLoginCount() {
        return this.totalFailedLoginCount;
    }

    @Override
    public Date getLastSuccessfulLoginDate() {
        return this.lastSuccessfulLoginDate;
    }

    @Override
    public Date getLastFailedLoginDate() {
        return this.lastFailedLoginDate;
    }

    public void setCurrentFailedLoginCount(int currentFailedLoginCount) {
        this.currentFailedLoginCount = currentFailedLoginCount;
    }

    public void setTotalFailedLoginCount(int totalFailedLoginCount) {
        this.totalFailedLoginCount = totalFailedLoginCount;
    }

    public void setLastSuccessfulLoginDate(Date lastSuccessfulLoginDate) {
        this.lastSuccessfulLoginDate = lastSuccessfulLoginDate;
    }

    public void setPreviousSuccessfulLoginDate(Date previousSuccessfulLoginDate) {
        this.previousSuccessfulLoginDate = previousSuccessfulLoginDate;
    }

    public void setLastFailedLoginDate(Date lastFailedLoginDate) {
        this.lastFailedLoginDate = lastFailedLoginDate;
    }
}

