/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.service;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.security.AllowedUrlsProvider;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.http.url.SameOrigin;
import com.atlassian.struts.multipart.AtlassianJakartaMultiPartRequest;
import com.atlassian.struts.multipart.MultiPartUtil;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.lang3.StringUtils;

public class DefaultXsrfTokenService
implements XsrfTokenService {
    @VisibleForTesting
    static final String VALIDATION_FAILED_ERROR_KEY = "atlassian.xwork.xsrf.badtoken";
    @VisibleForTesting
    static final String SECURITY_TOKEN_REQUIRED_ERROR_KEY = "atlassian.xwork.xsrf.notoken";
    private final XsrfTokenGenerator tokenGenerator;
    private final AllowedUrlsProvider allowedUrlsProvider;

    public DefaultXsrfTokenService(XsrfTokenGenerator tokenGenerator) {
        this(tokenGenerator, null);
    }

    public DefaultXsrfTokenService(XsrfTokenGenerator tokenGenerator, AllowedUrlsProvider allowedUrlsProvider) {
        this.tokenGenerator = tokenGenerator;
        this.allowedUrlsProvider = allowedUrlsProvider;
    }

    @Override
    public String generateValidToken(HttpServletRequest request) {
        return this.tokenGenerator.generateToken(request);
    }

    @Override
    public Optional<Message> validateToken(HttpServletRequest request) {
        HttpServletRequest unwrappedRequest = request;
        if (JakartaServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            unwrappedRequest = (HttpServletRequest)Optional.ofNullable(MultiPartUtil.unwrapMultiPartRequest((HttpServletRequest)request)).orElse((AtlassianJakartaMultiPartRequest)request);
        }
        if ("no-check".equals(unwrappedRequest.getHeader("X-Atlassian-Token"))) {
            return Optional.empty();
        }
        String token = unwrappedRequest.getParameter("atl_token");
        if (this.tokenGenerator.validateToken(unwrappedRequest, token) || this.requestOriginatesFromAppLink(request)) {
            return Optional.empty();
        }
        String errorMessage = token == null ? SECURITY_TOKEN_REQUIRED_ERROR_KEY : VALIDATION_FAILED_ERROR_KEY;
        return Optional.of(Message.getInstance((String)errorMessage));
    }

    private boolean requestOriginatesFromAppLink(HttpServletRequest request) {
        if (this.allowedUrlsProvider == null) {
            return false;
        }
        String headerValue = Optional.ofNullable(request.getHeader("Origin")).orElse(request.getHeader("Referer"));
        if (StringUtils.isBlank((CharSequence)headerValue)) {
            return false;
        }
        try {
            URI originUri = new URI(headerValue);
            if (this.isSameOrigin(new URI(request.getRequestURL().toString()), originUri)) {
                return false;
            }
            return this.allowedUrlsProvider.getUrls().stream().anyMatch(s -> this.isSameOrigin((URI)s, originUri));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private boolean isSameOrigin(URI uri, URI origin) {
        try {
            return SameOrigin.isSameOrigin((URI)uri, (URI)origin);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

