/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.websudo;

import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.security.websudo.AuthenticateAction;
import com.atlassian.confluence.security.websudo.WebSudoManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatorOverwrite;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Preconditions;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;

public class DefaultWebSudoManager
implements WebSudoManager {
    private final GlobalSettingsManager settingsManager;
    private static final String URL_AUTHENTICATE = "/authenticate.action";
    private static final String URL_ADMIN = "/admin/";
    private static final String URL_SETUP = "/setup/";
    private static final String SESSION_TIMESTAMP = "confluence.websudo.timestamp";
    private static final String REQUEST_ATTRIBUTE = "confluence.websudo.request";
    private static final String REQUIRE_AUTHENTICATION = "Require-Authentication";
    private static final String HAS_AUTHENTICATION = "Has-Authentication";

    public DefaultWebSudoManager(GlobalSettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public boolean isEnabled() {
        return !ConfluenceSystemProperties.isDevMode() && this.settingsManager.getGlobalSettings().getWebSudoEnabled() && !AuthenticatorOverwrite.isPasswordConfirmationDisabled();
    }

    public static boolean isElevatedDefaultPath(String servletPath) {
        return servletPath.startsWith(URL_ADMIN) || servletPath.startsWith(URL_SETUP);
    }

    @Override
    public boolean matches(String requestServletPath, Class<?> actionClass, Method method) {
        if (requestServletPath.startsWith(URL_AUTHENTICATE) && actionClass.isAssignableFrom(AuthenticateAction.class)) {
            return false;
        }
        if (DefaultWebSudoManager.isElevatedDefaultPath(requestServletPath)) {
            return method.getAnnotation(WebSudoNotRequired.class) == null && actionClass.getAnnotation(WebSudoNotRequired.class) == null && actionClass.getPackage().getAnnotation(WebSudoNotRequired.class) == null;
        }
        return method.getAnnotation(WebSudoRequired.class) != null || actionClass.getAnnotation(WebSudoRequired.class) != null || actionClass.getPackage().getAnnotation(WebSudoRequired.class) != null;
    }

    @Override
    public boolean hasValidSession(HttpSession session) {
        if (null == session) {
            return false;
        }
        long timeout = this.settingsManager.getGlobalSettings().getWebSudoTimeout();
        Long timestamp = (Long)session.getAttribute(SESSION_TIMESTAMP);
        long timeoutMillis = timeout * 60L * 1000L;
        return timestamp != null && timestamp >= this.currentTimeMillis() - timeoutMillis;
    }

    @Override
    public void startSession(HttpServletRequest request, HttpServletResponse response) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)response);
        request.getSession(true).setAttribute(SESSION_TIMESTAMP, (Object)this.currentTimeMillis());
        this.markWebSudoRequest(request);
        response.setHeader("X-Atlassian-WebSudo", HAS_AUTHENTICATION);
    }

    @Override
    public void markWebSudoRequest(HttpServletRequest request) {
        if (null == request) {
            return;
        }
        request.setAttribute(REQUEST_ATTRIBUTE, (Object)Boolean.TRUE);
    }

    @Override
    public boolean isWebSudoRequest(HttpServletRequest request) {
        return null != request && Boolean.TRUE.equals(request.getAttribute(REQUEST_ATTRIBUTE));
    }

    @Override
    public void invalidateSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session;
        HttpSession httpSession = session = null != request ? request.getSession(false) : null;
        if (null != session) {
            session.removeAttribute(SESSION_TIMESTAMP);
        }
        response.setHeader("X-Atlassian-WebSudo", REQUIRE_AUTHENTICATION);
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public URI buildAuthenticationRedirectUri(HttpServletRequest request) {
        String encoding = this.settingsManager.getGlobalSettings().getDefaultEncoding();
        String destination = GeneralUtil.getRequestUrl(request);
        try {
            return URI.create(request.getContextPath() + "/authenticate.action?destination=" + URLEncoder.encode(destination, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canExecuteRequest(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession(false);
        return !this.isEnabled() || this.isAccessTokenRequest(httpServletRequest) || this.hasValidSession(session);
    }

    @Override
    public void enforceWebSudoProtection(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.buildAuthenticationRedirectUri(request).toString());
    }

    private boolean isAccessTokenRequest(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute("com.atlassian.oath.request-flag") != null || httpServletRequest.getAttribute("access.token.request") != null;
    }
}

