/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.websudo;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.security.websudo.IPAllowListValidationResult;
import com.atlassian.ip.IPMatcher;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSudoIPAllowListManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSudoIPAllowListManager.class);
    public static final String WEBSUDO_ALLOWLIST_ENABLED_PROPERTY = "websudo.allowlist.enabled";
    public static final String WEBSUDO_ALLOWLIST_IP_PROPERTY = "websudo.allowlist.ip";
    public static final String WEBSUDO_ALLOWLIST_CIDR_PROPERTY = "websudo.allowlist.cidr";
    public static final String REMOTE_IP_HEADER_PROPERTY = "server.tomcat.remoteip.remote-ip-header";
    @VisibleForTesting
    static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private final boolean isEnabled;
    private final String requestIPHeader;
    private final IPMatcher ipMatcher;

    public WebSudoIPAllowListManager(ApplicationConfiguration applicationConfiguration) {
        this.isEnabled = applicationConfiguration.getBooleanProperty((Object)WEBSUDO_ALLOWLIST_ENABLED_PROPERTY);
        if (!this.isEnabled) {
            LOGGER.debug("Websudo allowlist is disabled, skipping other properties");
        }
        this.requestIPHeader = this.isEnabled ? (String)Optional.ofNullable(applicationConfiguration.getProperty((Object)REMOTE_IP_HEADER_PROPERTY)).orElse(X_FORWARDED_FOR_HEADER) : null;
        this.ipMatcher = this.isEnabled ? WebSudoIPAllowListManager.initialiseIpMatcher(applicationConfiguration) : null;
    }

    public IPAllowListValidationResult isAllowed(HttpServletRequest request) {
        if (!this.isEnabled) {
            LOGGER.debug("Websudo allowlist check is disabled, skipping check");
            return IPAllowListValidationResult.allowed();
        }
        String clientIP = Optional.ofNullable(request.getHeader(this.requestIPHeader)).orElse("");
        if (StringUtils.isBlank((CharSequence)clientIP)) {
            LOGGER.error("IP address is blank, read from header: {}", (Object)this.requestIPHeader);
            return IPAllowListValidationResult.denied(clientIP, this.requestIPHeader);
        }
        try {
            if (this.ipMatcher.matches(clientIP)) {
                return IPAllowListValidationResult.allowed(clientIP, this.requestIPHeader);
            }
            LOGGER.error("Secure admin websudo attempt rejected due to User IP {} read from header {} not in allow list.", (Object)clientIP, (Object)this.requestIPHeader);
            return IPAllowListValidationResult.denied(clientIP, this.requestIPHeader);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Exception while reading IP address {} read from header {}", new Object[]{clientIP, this.requestIPHeader, e});
            return IPAllowListValidationResult.denied(clientIP, this.requestIPHeader);
        }
    }

    private static IPMatcher initialiseIpMatcher(ApplicationConfiguration applicationConfiguration) {
        String allowedIps = (String)applicationConfiguration.getProperty((Object)WEBSUDO_ALLOWLIST_IP_PROPERTY);
        String allowedCidrBlocks = (String)applicationConfiguration.getProperty((Object)WEBSUDO_ALLOWLIST_CIDR_PROPERTY);
        IPMatcher.Builder builder = IPMatcher.builder();
        if (allowedIps != null) {
            WebSudoIPAllowListManager.addPattern(allowedIps, builder);
        }
        if (allowedCidrBlocks != null) {
            WebSudoIPAllowListManager.addPattern(allowedCidrBlocks, builder);
        }
        return builder.build();
    }

    private static void addPattern(String allowedPatterns, IPMatcher.Builder builder) {
        String[] configuredPatterns;
        for (String pattern : configuredPatterns = allowedPatterns.split(",")) {
            try {
                builder.addPattern(pattern.trim());
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Exception while parsing IP/CIDR Pattern {}. Ignoring part {}", new Object[]{allowedPatterns, pattern, e});
            }
        }
    }
}

