/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.server.ApplicationState;
import com.atlassian.confluence.server.ApplicationStatusService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

@UnrestrictedAccess
public class ApplicationStatusServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ApplicationStatusServlet.class);
    private ApplicationStatusService applicationStatusService;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationState state = this.getApplicationState(req);
        resp.setStatus(this.getStatus(state));
        resp.setContentType("application/json");
        resp.getWriter().append("{\"state\":\"").append(state.name()).append("\"}");
    }

    private int getStatus(ApplicationState state) {
        return switch (state) {
            case ApplicationState.ERROR -> 500;
            case ApplicationState.RUNNING, ApplicationState.FIRST_RUN -> 200;
            default -> 503;
        };
    }

    private ApplicationState getApplicationState(HttpServletRequest request) {
        ApplicationContext bootstrapContext;
        if (this.applicationStatusService == null && (bootstrapContext = BootstrapUtils.getBootstrapContext()) != null) {
            try {
                this.applicationStatusService = (ApplicationStatusService)bootstrapContext.getBean("applicationStatusService");
            }
            catch (BeansException e) {
                log.debug("Could not obtain ApplicationStatusService from Spring context ({})", (Object)e.getMessage());
            }
        }
        if (this.applicationStatusService != null) {
            return this.applicationStatusService.getState();
        }
        return ApplicationState.STARTING;
    }
}

