/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.google.common.io.ByteStreams;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.velocity.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class CssServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(CssServlet.class);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getServletPath();
        if (path.startsWith("/s/")) {
            path = this.stripResourcePrefix(path);
        }
        ServletContext servletContext = request.getSession().getServletContext();
        if (path.startsWith("/styles/")) {
            String forwardPath = FilenameUtils.removeExtension((String)path) + ".action";
            log.debug("Forwarding request for stylesheet at [{}] to Struts at [{}]", (Object)StringUtils.normalizePath((String)path), (Object)forwardPath);
            servletContext.getRequestDispatcher(forwardPath).forward((ServletRequest)request, (ServletResponse)response);
        } else {
            try (InputStream stylesheet = servletContext.getResourceAsStream(path);){
                if (stylesheet == null) {
                    log.debug("No static stylesheet found at [{}]", (Object)StringUtils.normalizePath((String)path));
                    response.sendError(404);
                    return;
                }
                log.debug("Sending static stylesheet response for [{}]", (Object)StringUtils.normalizePath((String)path));
                response.setContentType("text/css");
                ByteStreams.copy((InputStream)stylesheet, (OutputStream)response.getOutputStream());
            }
        }
    }

    private String stripResourcePrefix(String path) {
        Pattern pattern = Pattern.compile("^/s/.*/_(/.*)");
        Matcher match = pattern.matcher(path);
        if (match.find()) {
            String sanitizedPath = this.sanitizeForLogging(match.group(1));
            return sanitizedPath;
        }
        String sanitizedPath = this.sanitizeForLogging(path);
        log.error("No match found for path [{}]", (Object)sanitizedPath);
        throw new IllegalArgumentException("No match found for path [" + sanitizedPath + "]");
    }

    private String sanitizeForLogging(String input) {
        return input.replaceAll("[\r\n]", "");
    }
}

